/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.partition;

import cascading.tap.partition.DelimitedPartition;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class NamedPartition
extends DelimitedPartition {
    public static final String KEY_VALUE_DELIM = "=";
    protected String keyValueDelimiter = "=";
    protected boolean printNull = true;
    private transient Map<String, Integer> posMap;
    private transient Pattern keyValuePattern;

    public NamedPartition(Fields partitionFields) {
        super(partitionFields);
    }

    public NamedPartition(Fields partitionFields, String partDelimiter) {
        super(partitionFields, partDelimiter);
    }

    public NamedPartition(Fields partitionFields, String partDelimiter, String keyValueDelimiter) {
        super(partitionFields, partDelimiter);
        this.keyValueDelimiter = keyValueDelimiter;
    }

    public NamedPartition(Fields partitionFields, String partDelimiter, String keyValueDelimiter, String postfix) {
        super(partitionFields, partDelimiter, postfix);
        this.keyValueDelimiter = keyValueDelimiter;
    }

    public NamedPartition(Fields partitionFields, boolean printNull) {
        super(partitionFields);
        this.printNull = printNull;
    }

    public NamedPartition(Fields partitionFields, String partDelimiter, boolean printNull) {
        super(partitionFields, partDelimiter);
        this.printNull = printNull;
    }

    public NamedPartition(Fields partitionFields, String partDelimiter, String keyValueDelimiter, boolean printNull) {
        super(partitionFields, partDelimiter);
        this.keyValueDelimiter = keyValueDelimiter;
        this.printNull = printNull;
    }

    public NamedPartition(Fields partitionFields, String partDelimiter, String keyValueDelimiter, String postfix, boolean printNull) {
        super(partitionFields, partDelimiter, postfix);
        this.keyValueDelimiter = keyValueDelimiter;
        this.printNull = printNull;
    }

    protected Pattern getKeyValuePattern() {
        if (this.keyValuePattern == null) {
            this.keyValuePattern = Pattern.compile(this.keyValueDelimiter);
        }
        return this.keyValuePattern;
    }

    private Map<String, Integer> getPosMap() {
        if (this.posMap != null) {
            return this.posMap;
        }
        this.posMap = new HashMap<String, Integer>();
        this.partitionFields.forEach(f -> this.posMap.put(String.valueOf(f), this.partitionFields.getPos((Comparable)f)));
        return this.posMap;
    }

    @Override
    protected void parsePartitionInto(String partition, Fields partitionFields, int numSplits, TupleEntry tupleEntry) {
        String[] split;
        Map<String, Integer> posMap = this.getPosMap();
        for (String entry : split = this.getPattern().split(partition, numSplits)) {
            String[] keyValue = this.getKeyValuePattern().split(entry, 2);
            tupleEntry.setString(posMap.get(this.mapPartitionNameToFieldName(keyValue[0])), keyValue[1]);
        }
    }

    @Override
    protected String formatPartitionWith(TupleEntry tupleEntry, String delimiter) {
        Iterable<String[]> iterable = tupleEntry.asPairwiseIterable();
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        for (String[] s : iterable) {
            if (count != 0) {
                buffer.append(delimiter);
            }
            buffer.append(this.mapFieldNameToPartitionName(s[0]));
            buffer.append(this.keyValueDelimiter);
            if (this.printNull || s[1] != null) {
                buffer.append(s[1]);
            }
            ++count;
        }
        return buffer.toString();
    }

    protected String mapPartitionNameToFieldName(String partitionName) {
        return partitionName;
    }

    protected String mapFieldNameToPartitionName(String fieldName) {
        return fieldName;
    }
}

