/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.partition;

import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.util.regex.Pattern;

public class DelimitedPartition
implements Partition {
    public static final String PATH_DELIM = "/";
    final Fields partitionFields;
    final String delimiter;
    final String postfix;
    int numSplits;
    transient Pattern pattern;

    public DelimitedPartition(Fields partitionFields) {
        this(partitionFields, null, null);
    }

    public DelimitedPartition(Fields partitionFields, String delimiter) {
        this(partitionFields, delimiter, null);
    }

    public DelimitedPartition(Fields partitionFields, String delimiter, String postfix) {
        if (partitionFields == null) {
            throw new IllegalArgumentException("partitionFields must not be null");
        }
        if (!partitionFields.isDefined()) {
            throw new IllegalArgumentException("partitionFields must be defined, got: " + partitionFields.printVerbose());
        }
        this.partitionFields = partitionFields;
        String string = this.delimiter = delimiter == null ? PATH_DELIM : delimiter;
        postfix = Util.isEmpty(postfix) ? null : (postfix.startsWith(this.delimiter) ? postfix.substring(this.delimiter.length()) : postfix);
        this.numSplits = partitionFields.size() + (postfix != null ? postfix.split(this.delimiter).length : 0);
        this.postfix = postfix == null ? null : delimiter + postfix;
    }

    @Override
    public int getPathDepth() {
        return this.numSplits;
    }

    @Override
    public Fields getPartitionFields() {
        return this.partitionFields;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.delimiter);
        }
        return this.pattern;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getPostfix() {
        return this.postfix;
    }

    @Override
    public void toTuple(String partition, TupleEntry tupleEntry) {
        if (partition.startsWith(this.delimiter)) {
            partition = partition.substring(1);
        }
        this.parsePartitionInto(partition, this.partitionFields, this.numSplits, tupleEntry);
    }

    protected void parsePartitionInto(String partition, Fields partitionFields, int numSplits, TupleEntry tupleEntry) {
        Object[] split = this.getPattern().split(partition, numSplits);
        tupleEntry.setCanonicalValues(split, 0, partitionFields.size());
    }

    @Override
    public String toPartition(TupleEntry tupleEntry) {
        String partition = this.formatPartitionWith(tupleEntry, this.delimiter);
        if (this.postfix != null) {
            partition = partition + this.postfix;
        }
        return partition;
    }

    protected String formatPartitionWith(TupleEntry tupleEntry, String delimiter) {
        return Util.join(tupleEntry.asIterableOf(String.class), delimiter, true);
    }
}

