/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.Flow;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.planner.ScopedElement;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.PropertySanitizer;
import cascading.management.annotation.Visibility;
import cascading.property.ConfigDef;
import cascading.scheme.Scheme;
import cascading.tap.DecoratorTap;
import cascading.tap.SinkMode;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import cascading.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class Tap<Config, Input, Output>
implements ScopedElement,
FlowElement,
Serializable,
Traceable {
    private Scheme<Config, Input, Output, ?, ?> scheme;
    SinkMode sinkMode = SinkMode.KEEP;
    private ConfigDef configDef;
    private ConfigDef nodeConfigDef;
    private ConfigDef stepConfigDef;
    private final String id = Util.createUniqueID();
    private String trace = TraceUtil.captureDebugTrace(this);

    public static Tap[] taps(Tap ... taps) {
        return taps;
    }

    public static synchronized String id(Tap tap) {
        if (tap instanceof DecoratorTap) {
            return Tap.id(((DecoratorTap)tap).getOriginal());
        }
        return tap.id;
    }

    protected Tap() {
    }

    protected Tap(Scheme<Config, Input, Output, ?, ?> scheme) {
        this.setScheme(scheme);
    }

    protected Tap(Scheme<Config, Input, Output, ?, ?> scheme, SinkMode sinkMode) {
        this.setScheme(scheme);
        if (sinkMode != null) {
            this.sinkMode = sinkMode;
        }
    }

    protected void setScheme(Scheme<Config, Input, Output, ?, ?> scheme) {
        this.scheme = scheme;
    }

    public Scheme<Config, Input, Output, ?, ?> getScheme() {
        return this.scheme;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public void flowConfInit(Flow<Config> flow) {
    }

    public void sourceConfInit(FlowProcess<? extends Config> flowProcess, Config conf) {
        this.getScheme().sourceConfInit(flowProcess, this, (Config)conf);
    }

    public void sinkConfInit(FlowProcess<? extends Config> flowProcess, Config conf) {
        this.getScheme().sinkConfInit(flowProcess, this, (Config)conf);
    }

    @Property(name="identifier", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The resource this instance represents")
    @PropertySanitizer(value="cascading.management.annotation.URISanitizer")
    public abstract String getIdentifier();

    public Fields getSourceFields() {
        return this.getScheme().getSourceFields();
    }

    public Fields getSinkFields() {
        return this.getScheme().getSinkFields();
    }

    public abstract TupleEntryIterator openForRead(FlowProcess<? extends Config> var1, Input var2) throws IOException;

    public TupleEntryIterator openForRead(FlowProcess<? extends Config> flowProcess) throws IOException {
        return this.openForRead(flowProcess, null);
    }

    public abstract TupleEntryCollector openForWrite(FlowProcess<? extends Config> var1, Output var2) throws IOException;

    public TupleEntryCollector openForWrite(FlowProcess<? extends Config> flowProcess) throws IOException {
        if (this.isReplace()) {
            this.deleteResource((Config)flowProcess);
        }
        return this.openForWrite(flowProcess, null);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields incomingFields;
        int count = 0;
        for (Scope incomingScope : incomingScopes) {
            Fields incomingFields2 = incomingScope.getIncomingTapFields();
            if (incomingFields2 == null) continue;
            try {
                incomingFields2.select(this.getSinkFields());
            }
            catch (FieldsResolverException exception) {
                throw new TapException(this, exception.getSourceFields(), exception.getSelectorFields(), exception);
            }
            ++count;
        }
        if (count > 1) {
            throw new FlowException("Tap may not have more than one incoming Scope");
        }
        Fields fields = incomingFields = incomingScopes.size() == 0 ? null : incomingScopes.iterator().next().getIncomingTapFields();
        if (incomingFields != null && (this.isSource() && this.getSourceFields().equals(Fields.UNKNOWN) || this.isSink() && this.getSinkFields().equals(Fields.ALL))) {
            return new Scope(incomingFields);
        }
        if (count == 1) {
            return new Scope(this.getSinkFields());
        }
        return new Scope(this.getSourceFields());
    }

    public Fields retrieveSourceFields(FlowProcess<? extends Config> flowProcess) {
        return this.getScheme().retrieveSourceFields(flowProcess, this);
    }

    public void presentSourceFields(FlowProcess<? extends Config> flowProcess, Fields fields) {
        this.getScheme().presentSourceFields(flowProcess, this, fields);
    }

    public Fields retrieveSinkFields(FlowProcess<? extends Config> flowProcess) {
        return this.getScheme().retrieveSinkFields(flowProcess, this);
    }

    public void presentSinkFields(FlowProcess<? extends Config> flowProcess, Fields fields) {
        this.getScheme().presentSinkFields(flowProcess, this, fields);
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        return incomingScope.getIncomingTapFields();
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        return incomingScope.getIncomingTapFields();
    }

    public String getFullIdentifier(FlowProcess<? extends Config> flowProcess) {
        return this.getFullIdentifier(flowProcess.getConfig());
    }

    public String getFullIdentifier(Config conf) {
        return this.getIdentifier();
    }

    public boolean createResource(FlowProcess<? extends Config> flowProcess) throws IOException {
        return this.createResource(flowProcess.getConfig());
    }

    public abstract boolean createResource(Config var1) throws IOException;

    public boolean deleteResource(FlowProcess<? extends Config> flowProcess) throws IOException {
        return this.deleteResource(flowProcess.getConfig());
    }

    public abstract boolean deleteResource(Config var1) throws IOException;

    public boolean prepareResourceForRead(Config conf) throws IOException {
        return true;
    }

    public boolean prepareResourceForWrite(Config conf) throws IOException {
        return true;
    }

    public boolean commitResource(Config conf) throws IOException {
        return true;
    }

    public boolean rollbackResource(Config conf) throws IOException {
        return true;
    }

    public boolean resourceExists(FlowProcess<? extends Config> flowProcess) throws IOException {
        return this.resourceExists(flowProcess.getConfig());
    }

    public abstract boolean resourceExists(Config var1) throws IOException;

    public long getModifiedTime(FlowProcess<? extends Config> flowProcess) throws IOException {
        return this.getModifiedTime(flowProcess.getConfig());
    }

    public abstract long getModifiedTime(Config var1) throws IOException;

    public SinkMode getSinkMode() {
        return this.sinkMode;
    }

    public boolean isKeep() {
        return this.sinkMode == SinkMode.KEEP;
    }

    public boolean isReplace() {
        return this.sinkMode == SinkMode.REPLACE;
    }

    public boolean isUpdate() {
        return this.sinkMode == SinkMode.UPDATE;
    }

    public boolean isSink() {
        return this.getScheme().isSink();
    }

    public boolean isSource() {
        return this.getScheme().isSource();
    }

    public boolean isTemporary() {
        return false;
    }

    @Override
    public ConfigDef getConfigDef() {
        if (this.configDef == null) {
            this.configDef = new ConfigDef();
        }
        return this.configDef;
    }

    @Override
    public boolean hasConfigDef() {
        return this.configDef != null && !this.configDef.isEmpty();
    }

    @Override
    public ConfigDef getNodeConfigDef() {
        if (this.nodeConfigDef == null) {
            this.nodeConfigDef = new ConfigDef();
        }
        return this.nodeConfigDef;
    }

    @Override
    public boolean hasNodeConfigDef() {
        return this.nodeConfigDef != null && !this.nodeConfigDef.isEmpty();
    }

    @Override
    public ConfigDef getStepConfigDef() {
        if (this.stepConfigDef == null) {
            this.stepConfigDef = new ConfigDef();
        }
        return this.stepConfigDef;
    }

    @Override
    public boolean hasStepConfigDef() {
        return this.stepConfigDef != null && !this.stepConfigDef.isEmpty();
    }

    public Spliterator<TupleEntry> spliterator(FlowProcess<? extends Config> flowProcess) {
        return this.splititerator(this.openForReadUnchecked(flowProcess));
    }

    protected TupleEntryIterator openForReadUnchecked(FlowProcess<? extends Config> flowProcess) {
        try {
            return this.openForRead(flowProcess);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    protected Spliterator<TupleEntry> splititerator(TupleEntryIterator iterator) {
        return Spliterators.spliteratorUnknownSize(iterator, 0);
    }

    public Stream<TupleEntry> entryStream(FlowProcess<? extends Config> flowProcess) {
        TupleEntryIterator iterator = this.openForReadUnchecked(flowProcess);
        Spliterator<TupleEntry> spliterator = this.splititerator(iterator);
        try {
            return (Stream)StreamSupport.stream(spliterator, false).onClose(Tap.asUncheckedRunnable(iterator));
        }
        catch (Error | RuntimeException error) {
            try {
                iterator.close();
            }
            catch (IOException exception) {
                try {
                    error.addSuppressed(exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw error;
        }
    }

    public Stream<TupleEntry> entryStreamCopy(FlowProcess<? extends Config> flowProcess) {
        return this.entryStream(flowProcess).map(TupleEntry::new);
    }

    public Stream<TupleEntry> entryStream(FlowProcess<? extends Config> flowProcess, Fields selector) {
        return this.entryStream(flowProcess).map(tupleEntry -> tupleEntry.selectEntry(selector));
    }

    public Stream<TupleEntry> entryStreamCopy(FlowProcess<? extends Config> flowProcess, Fields selector) {
        return this.entryStream(flowProcess).map(tupleEntry -> tupleEntry.selectEntryCopy(selector));
    }

    public Stream<Tuple> tupleStream(FlowProcess<? extends Config> flowProcess) {
        return this.entryStream(flowProcess).map(TupleEntry::getTuple);
    }

    public Stream<Tuple> tupleStreamCopy(FlowProcess<? extends Config> flowProcess) {
        return this.entryStream(flowProcess).map(TupleEntry::getTupleCopy);
    }

    public Stream<Tuple> tupleStream(FlowProcess<? extends Config> flowProcess, Fields selector) {
        return this.entryStream(flowProcess).map(tupleEntry -> tupleEntry.selectTuple(selector));
    }

    public Stream<Tuple> tupleStreamCopy(FlowProcess<? extends Config> flowProcess, Fields selector) {
        return this.entryStream(flowProcess).map(tupleEntry -> tupleEntry.selectTupleCopy(selector));
    }

    private static Runnable asUncheckedRunnable(Closeable closeable) {
        return () -> {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tap tap = (Tap)object;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(tap.getIdentifier()) : tap.getIdentifier() != null) {
            return false;
        }
        return !(this.getScheme() != null ? !this.getScheme().equals(tap.getScheme()) : tap.getScheme() != null);
    }

    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.getIdentifier() != null) {
            return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"][\"" + Util.sanitizeUrl(this.getIdentifier()) + "\"]";
        }
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"][not initialized]";
    }
}

