/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.FlowProcess;
import cascading.tap.AdaptorTap;
import cascading.tap.Tap;
import cascading.tap.type.FileType;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.function.Function;

public class FileAdaptorTap<TConfig, TInput, TOutput, OConfig, OInput, OOutput>
extends AdaptorTap<TConfig, TInput, TOutput, OConfig, OInput, OOutput>
implements FileType<TConfig> {
    @ConstructorProperties(value={"original", "processProvider", "configProvider"})
    public FileAdaptorTap(Tap<OConfig, OInput, OOutput> original, Function<FlowProcess<? extends TConfig>, FlowProcess<? extends OConfig>> processProvider, Function<TConfig, OConfig> configProvider) {
        super(original, processProvider, configProvider);
        if (!(original instanceof FileType)) {
            throw new IllegalArgumentException("original Tap must be of type: " + FileType.class.getName());
        }
    }

    protected FileType<TConfig> getFileOriginal() {
        return (FileType)((Object)this.getOriginal());
    }

    @Override
    public boolean isDirectory(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.getFileOriginal().isDirectory((TConfig)((FlowProcess)this.processProvider.apply(flowProcess)));
    }

    @Override
    public boolean isDirectory(TConfig conf) throws IOException {
        return this.getFileOriginal().isDirectory(this.configProvider.apply(conf));
    }

    @Override
    public String[] getChildIdentifiers(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.getFileOriginal().getChildIdentifiers(this.processProvider.apply(flowProcess));
    }

    @Override
    public String[] getChildIdentifiers(TConfig conf) throws IOException {
        return this.getFileOriginal().getChildIdentifiers(this.configProvider.apply(conf));
    }

    @Override
    public String[] getChildIdentifiers(FlowProcess<? extends TConfig> flowProcess, int depth, boolean fullyQualified) throws IOException {
        return this.getFileOriginal().getChildIdentifiers(this.processProvider.apply(flowProcess), depth, fullyQualified);
    }

    @Override
    public String[] getChildIdentifiers(TConfig conf, int depth, boolean fullyQualified) throws IOException {
        return this.getFileOriginal().getChildIdentifiers(this.configProvider.apply(conf), depth, fullyQualified);
    }

    @Override
    public long getSize(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.getFileOriginal().getSize(this.processProvider.apply(flowProcess));
    }

    @Override
    public long getSize(TConfig conf) throws IOException {
        return this.getFileOriginal().getSize(this.configProvider.apply(conf));
    }
}

