/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.property.ConfigDef;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;

public class AdaptorTap<TConfig, TInput, TOutput, OConfig, OInput, OOutput>
extends Tap<TConfig, TInput, TOutput> {
    protected Tap<OConfig, OInput, OOutput> original;
    protected Function<FlowProcess<? extends TConfig>, FlowProcess<? extends OConfig>> processProvider;
    protected Function<TConfig, OConfig> configProvider;

    @ConstructorProperties(value={"original", "processProvider", "configProvider"})
    public AdaptorTap(Tap<OConfig, OInput, OOutput> original, Function<FlowProcess<? extends TConfig>, FlowProcess<? extends OConfig>> processProvider, Function<TConfig, OConfig> configProvider) {
        this.setOriginal(original);
        if (processProvider == null) {
            throw new IllegalArgumentException("processProvider may not be null");
        }
        if (configProvider == null) {
            throw new IllegalArgumentException("confProvider may not be null");
        }
        this.processProvider = processProvider;
        this.configProvider = configProvider;
    }

    public Tap<OConfig, OInput, OOutput> getOriginal() {
        return this.original;
    }

    protected void setOriginal(Tap<OConfig, OInput, OOutput> original) {
        if (original == null) {
            throw new IllegalArgumentException("wrapped tap value may not be null");
        }
        this.original = original;
    }

    @Override
    public Scheme<TConfig, TInput, TOutput, ?, ?> getScheme() {
        throw new UnsupportedOperationException("cannot retrieve Scheme");
    }

    @Override
    public String getTrace() {
        return this.original.getTrace();
    }

    @Override
    public void flowConfInit(Flow<TConfig> flow) {
    }

    @Override
    public void sourceConfInit(FlowProcess<? extends TConfig> flowProcess, TConfig conf) {
        this.original.sourceConfInit(this.processProvider.apply(flowProcess), this.configProvider.apply(conf));
    }

    @Override
    public void sinkConfInit(FlowProcess<? extends TConfig> flowProcess, TConfig conf) {
        this.original.sinkConfInit(this.processProvider.apply(flowProcess), this.configProvider.apply(conf));
    }

    @Override
    public String getIdentifier() {
        return this.original.getIdentifier();
    }

    @Override
    public Fields getSourceFields() {
        return this.original.getSourceFields();
    }

    @Override
    public Fields getSinkFields() {
        return this.original.getSinkFields();
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<? extends TConfig> flowProcess, TInput input) throws IOException {
        return this.original.openForRead(this.processProvider.apply(flowProcess), null);
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.openForRead(this.processProvider.apply(flowProcess));
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<? extends TConfig> flowProcess, TOutput output) throws IOException {
        return this.original.openForWrite(this.processProvider.apply(flowProcess), null);
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.openForWrite(this.processProvider.apply(flowProcess));
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        return this.original.outgoingScopeFor(incomingScopes);
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<? extends TConfig> flowProcess) {
        return this.original.retrieveSourceFields(this.processProvider.apply(flowProcess));
    }

    @Override
    public void presentSourceFields(FlowProcess<? extends TConfig> flowProcess, Fields fields) {
        this.original.presentSourceFields(this.processProvider.apply(flowProcess), fields);
    }

    @Override
    public Fields retrieveSinkFields(FlowProcess<? extends TConfig> flowProcess) {
        return this.original.retrieveSinkFields(this.processProvider.apply(flowProcess));
    }

    @Override
    public void presentSinkFields(FlowProcess<? extends TConfig> flowProcess, Fields fields) {
        this.original.presentSinkFields(this.processProvider.apply(flowProcess), fields);
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        return this.original.resolveIncomingOperationArgumentFields(incomingScope);
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        return this.original.resolveIncomingOperationPassThroughFields(incomingScope);
    }

    @Override
    public String getFullIdentifier(FlowProcess<? extends TConfig> flowProcess) {
        return this.original.getFullIdentifier((OConfig)this.processProvider.apply(flowProcess));
    }

    @Override
    public String getFullIdentifier(TConfig conf) {
        return this.original.getFullIdentifier(this.configProvider.apply(conf));
    }

    @Override
    public boolean createResource(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.createResource((OConfig)this.processProvider.apply(flowProcess));
    }

    @Override
    public boolean createResource(TConfig conf) throws IOException {
        return this.original.createResource(this.configProvider.apply(conf));
    }

    @Override
    public boolean deleteResource(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.deleteResource((OConfig)this.processProvider.apply(flowProcess));
    }

    @Override
    public boolean deleteResource(TConfig conf) throws IOException {
        return this.original.deleteResource(this.configProvider.apply(conf));
    }

    @Override
    public boolean prepareResourceForRead(TConfig conf) throws IOException {
        return this.original.prepareResourceForRead(this.configProvider.apply(conf));
    }

    @Override
    public boolean prepareResourceForWrite(TConfig conf) throws IOException {
        return this.original.prepareResourceForWrite(this.configProvider.apply(conf));
    }

    @Override
    public boolean commitResource(TConfig conf) throws IOException {
        return this.original.commitResource(this.configProvider.apply(conf));
    }

    @Override
    public boolean rollbackResource(TConfig conf) throws IOException {
        return this.original.rollbackResource(this.configProvider.apply(conf));
    }

    @Override
    public boolean resourceExists(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.resourceExists((OConfig)this.processProvider.apply(flowProcess));
    }

    @Override
    public boolean resourceExists(TConfig conf) throws IOException {
        return this.original.resourceExists(this.configProvider.apply(conf));
    }

    @Override
    public long getModifiedTime(FlowProcess<? extends TConfig> flowProcess) throws IOException {
        return this.original.getModifiedTime((OConfig)this.processProvider.apply(flowProcess));
    }

    @Override
    public long getModifiedTime(TConfig conf) throws IOException {
        return this.original.getModifiedTime(this.configProvider.apply(conf));
    }

    @Override
    public SinkMode getSinkMode() {
        return this.original.getSinkMode();
    }

    @Override
    public boolean isKeep() {
        return this.original.isKeep();
    }

    @Override
    public boolean isReplace() {
        return this.original.isReplace();
    }

    @Override
    public boolean isUpdate() {
        return this.original.isUpdate();
    }

    @Override
    public boolean isSink() {
        return this.original.isSink();
    }

    @Override
    public boolean isSource() {
        return this.original.isSource();
    }

    @Override
    public boolean isTemporary() {
        return this.original.isTemporary();
    }

    @Override
    public ConfigDef getConfigDef() {
        return this.original.getConfigDef();
    }

    @Override
    public boolean hasConfigDef() {
        return this.original.hasConfigDef();
    }

    @Override
    public ConfigDef getNodeConfigDef() {
        return this.original.getNodeConfigDef();
    }

    @Override
    public boolean hasNodeConfigDef() {
        return this.original.hasNodeConfigDef();
    }

    @Override
    public ConfigDef getStepConfigDef() {
        return this.original.getStepConfigDef();
    }

    @Override
    public boolean hasStepConfigDef() {
        return this.original.hasStepConfigDef();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tap<OConfig, OInput, OOutput> tap = (Tap<OConfig, OInput, OOutput>)object;
        if (tap instanceof AdaptorTap) {
            tap = ((AdaptorTap)tap).getOriginal();
        }
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(tap.getIdentifier()) : tap.getIdentifier() != null) {
            return false;
        }
        return !(this.original.getScheme() != null ? !this.original.getScheme().equals(tap.getScheme()) : tap.getScheme() != null);
    }

    @Override
    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.original.getScheme() != null ? this.original.getScheme().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        if (this.getIdentifier() != null) {
            return this.getClass().getSimpleName() + "[\"" + this.original.getScheme() + "\"][\"" + Util.sanitizeUrl(this.getIdentifier()) + "\"]";
        }
        return this.getClass().getSimpleName() + "[\"" + this.original.getScheme() + "\"][not initialized]";
    }
}

