/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.process;

import cascading.flow.process.ProcessFlowStep;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.FlowStepStats;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class ProcessStepStats
extends FlowStepStats {
    private final Map<String, Map<String, Long>> counters;
    private final long lastFetch;

    public ProcessStepStats(ClientState clientState, Map<String, Map<String, Long>> counters, ProcessFlowStep step) {
        super(step, clientState);
        this.counters = counters;
        this.lastFetch = this.counters != null ? System.currentTimeMillis() : -1L;
    }

    @Override
    public void recordChildStats() {
    }

    @Override
    public String getProcessStepID() {
        return null;
    }

    @Override
    public long getLastSuccessfulCounterFetchTime() {
        return this.lastFetch;
    }

    @Override
    public Collection<String> getCounterGroups() {
        return this.counters.keySet();
    }

    @Override
    public Collection<String> getCountersFor(String group) {
        Map<String, Long> groupCollection = this.counters.get(group);
        if (groupCollection == null) {
            return Collections.emptySet();
        }
        return groupCollection.keySet();
    }

    @Override
    public long getCounterValue(Enum counter) {
        Map<String, Long> counterMap = this.counters.get(counter.getDeclaringClass().getName());
        String counterString = counter.toString();
        if (counterMap == null || !counterMap.containsKey(counterString)) {
            return 0L;
        }
        return counterMap.get(counterString);
    }

    @Override
    public long getCounterValue(String group, String counter) {
        Map<String, Long> counterMap = this.counters.get(group);
        if (counterMap == null || !counterMap.containsKey(counter)) {
            return 0L;
        }
        return counterMap.get(counter);
    }

    @Override
    public void captureDetail() {
    }

    @Override
    public void captureDetail(CascadingStats.Type depth) {
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        Collection<String> counters = this.getCounterGroups();
        HashSet<String> results = new HashSet<String>();
        for (String counter : counters) {
            if (!counter.matches(regex)) continue;
            results.add(counter);
        }
        return Collections.unmodifiableCollection(results);
    }

    @Override
    public Collection getChildren() {
        return Collections.emptyList();
    }
}

