/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.process;

import cascading.CascadingException;
import cascading.flow.Flow;
import cascading.flow.process.ProcessFlowStep;
import cascading.management.state.ClientState;
import cascading.stats.FlowStats;
import cascading.stats.FlowStepStats;
import cascading.stats.process.ProcessStepStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import riffle.process.scheduler.ProcessException;
import riffle.process.scheduler.ProcessWrapper;

public class ProcessFlowStats
extends FlowStats {
    private ProcessWrapper processWrapper;

    public ProcessFlowStats(Flow flow, ClientState clientState, ProcessWrapper processWrapper) {
        super(flow, clientState);
        this.processWrapper = processWrapper;
    }

    @Override
    public List<FlowStepStats> getFlowStepStats() {
        return this.getChildrenInternal();
    }

    @Override
    public Collection getChildren() {
        return this.getChildrenInternal();
    }

    private List<FlowStepStats> getChildrenInternal() {
        try {
            if (!this.processWrapper.hasChildren()) {
                if (this.processWrapper.hasCounters()) {
                    return Arrays.asList(new ProcessStepStats(this.clientState, this.processWrapper.getCounters(), new ProcessFlowStep(this.processWrapper, 1)));
                }
                return Collections.emptyList();
            }
            ArrayList<FlowStepStats> childStepStats = new ArrayList<FlowStepStats>();
            int counter = 0;
            for (Object process : this.processWrapper.getChildren()) {
                ProcessWrapper childWrapper = new ProcessWrapper(process);
                if (!childWrapper.hasCounters()) continue;
                ProcessStepStats processStepStats = new ProcessStepStats(this.clientState, childWrapper.getCounters(), new ProcessFlowStep(this.processWrapper, counter));
                ++counter;
                childStepStats.add(processStepStats);
            }
            return childStepStats;
        }
        catch (ProcessException exception) {
            throw new CascadingException(exception);
        }
    }

    @Override
    public int getStepsCount() {
        try {
            if (!this.processWrapper.hasChildren()) {
                return 1;
            }
            return this.processWrapper.getChildren().size();
        }
        catch (ProcessException exception) {
            throw new CascadingException(exception);
        }
    }
}

