/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.FlowNodeStats;
import cascading.util.ProcessLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FlowStepStats
extends CascadingStats<FlowNodeStats> {
    private final FlowStep flowStep;
    private Map<String, FlowNodeStats> flowNodeStatsMap = new LinkedHashMap<String, FlowNodeStats>();

    protected FlowStepStats(FlowStep flowStep, ClientState clientState) {
        super(flowStep.getName(), clientState);
        this.flowStep = flowStep;
        this.flowStep.setFlowStepStats(this);
    }

    @Override
    protected ProcessLogger getProcessLogger() {
        if (this.flowStep != null && this.flowStep instanceof ProcessLogger) {
            return (ProcessLogger)((Object)this.flowStep);
        }
        return ProcessLogger.NULL;
    }

    @Override
    public String getID() {
        return this.flowStep.getID();
    }

    @Override
    public CascadingStats.Type getType() {
        return CascadingStats.Type.STEP;
    }

    public FlowStep getFlowStep() {
        return this.flowStep;
    }

    public void addNodeStats(FlowNodeStats flowNodeStats) {
        this.flowNodeStatsMap.put(flowNodeStats.getID(), flowNodeStats);
    }

    protected Map<String, FlowNodeStats> getFlowNodeStatsMap() {
        return this.flowNodeStatsMap;
    }

    public List<FlowNodeStats> getFlowNodeStats() {
        return new ArrayList<FlowNodeStats>(this.flowNodeStatsMap.values());
    }

    public int getNodesCount() {
        return this.flowNodeStatsMap.size();
    }

    protected Collection<String> getFlowNodeIDs() {
        return this.flowNodeStatsMap.keySet();
    }

    @Override
    public Collection<FlowNodeStats> getChildren() {
        return this.flowNodeStatsMap.values();
    }

    @Override
    public FlowNodeStats getChildWith(String id) {
        return this.flowNodeStatsMap.get(id);
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordFlowStep(this.flowStep);
    }

    @Override
    public String toString() {
        return "Step{" + this.getStatsString() + '}';
    }

    public boolean hasCapturedFinalDetail() {
        Collection<FlowNodeStats> values = this.flowNodeStatsMap.values();
        for (FlowNodeStats nodeStats : values) {
            if (nodeStats.getChildren().isEmpty() || nodeStats.hasCapturedFinalDetail()) continue;
            return false;
        }
        return true;
    }

    public abstract void recordChildStats();

    public abstract String getProcessStepID();

    public String getProcessStatusURL() {
        return null;
    }
}

