/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.Flow;
import cascading.management.state.ClientState;
import cascading.property.AppProps;
import cascading.stats.CascadingStats;
import cascading.stats.FlowStepStats;
import cascading.util.ProcessLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FlowStats
extends CascadingStats<FlowStepStats> {
    final Flow flow;
    final Map<String, FlowStepStats> flowStepStatsMap = new LinkedHashMap<String, FlowStepStats>();

    public FlowStats(Flow flow, ClientState clientState) {
        super(flow.getName(), clientState);
        this.flow = flow;
    }

    @Override
    protected ProcessLogger getProcessLogger() {
        if (this.flow != null && this.flow instanceof ProcessLogger) {
            return (ProcessLogger)((Object)this.flow);
        }
        return ProcessLogger.NULL;
    }

    public Map<Object, Object> getFlowProperties() {
        return this.flow.getConfigAsProperties();
    }

    public String getAppID() {
        return AppProps.getApplicationID(this.getFlowProperties());
    }

    public String getAppName() {
        return AppProps.getApplicationName(this.getFlowProperties());
    }

    @Override
    public String getID() {
        return this.flow.getID();
    }

    @Override
    public CascadingStats.Type getType() {
        return CascadingStats.Type.FLOW;
    }

    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordFlow(this.flow);
    }

    public void addStepStats(FlowStepStats flowStepStats) {
        this.flowStepStatsMap.put(flowStepStats.getID(), flowStepStats);
    }

    public List<FlowStepStats> getFlowStepStats() {
        return new ArrayList<FlowStepStats>(this.flowStepStatsMap.values());
    }

    public int getStepsCount() {
        return this.flowStepStatsMap.size();
    }

    @Override
    public long getLastSuccessfulCounterFetchTime() {
        long max = -1L;
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            max = Math.max(max, flowStepStats.getLastSuccessfulCounterFetchTime());
        }
        return max;
    }

    @Override
    public Collection<String> getCounterGroups() {
        HashSet<String> results = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            results.addAll(flowStepStats.getCounterGroups());
        }
        return results;
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        HashSet<String> results = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            results.addAll(flowStepStats.getCounterGroupsMatching(regex));
        }
        return results;
    }

    @Override
    public Collection<String> getCountersFor(String group) {
        HashSet<String> results = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            results.addAll(flowStepStats.getCountersFor(group));
        }
        return results;
    }

    @Override
    public long getCounterValue(Enum counter) {
        long value = 0L;
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            value += flowStepStats.getCounterValue(counter);
        }
        return value;
    }

    @Override
    public long getCounterValue(String group, String counter) {
        long value = 0L;
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            value += flowStepStats.getCounterValue(group, counter);
        }
        return value;
    }

    @Override
    public void captureDetail(CascadingStats.Type depth) {
        if (!this.getType().isChild(depth)) {
            return;
        }
        for (FlowStepStats flowStepStats : this.flowStepStatsMap.values()) {
            flowStepStats.captureDetail(depth);
        }
    }

    @Override
    public Collection<FlowStepStats> getChildren() {
        return this.flowStepStatsMap.values();
    }

    @Override
    public FlowStepStats getChildWith(String id) {
        return this.flowStepStatsMap.get(id);
    }

    @Override
    protected String getStatsString() {
        return super.getStatsString() + ", stepsCount=" + this.getStepsCount();
    }

    @Override
    public String toString() {
        return "Flow{" + this.getStatsString() + '}';
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FlowStats)) {
            return false;
        }
        return this.getID().equals(((FlowStats)object).getID());
    }
}

