/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.FlowNode;
import cascading.flow.planner.BaseFlowNode;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.FlowSliceStats;
import cascading.util.ProcessLogger;

public abstract class FlowNodeStats
extends CascadingStats<FlowSliceStats> {
    private final FlowNode flowNode;
    protected boolean hasCapturedFinalDetail = false;

    protected FlowNodeStats(FlowNode flowNode, ClientState clientState) {
        super(flowNode.getName(), clientState);
        this.flowNode = flowNode;
        ((BaseFlowNode)this.flowNode).setFlowNodeStats(this);
    }

    public abstract String getKind();

    @Override
    protected ProcessLogger getProcessLogger() {
        if (this.flowNode != null && this.flowNode instanceof ProcessLogger) {
            return (ProcessLogger)((Object)this.flowNode);
        }
        return ProcessLogger.NULL;
    }

    @Override
    public String getID() {
        return this.flowNode.getID();
    }

    @Override
    public CascadingStats.Type getType() {
        return CascadingStats.Type.NODE;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public int getOrdinal() {
        return this.flowNode.getOrdinal();
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordFlowNode(this.flowNode);
    }

    @Override
    public String toString() {
        return "Node{" + this.getStatsString() + '}';
    }

    public abstract void recordChildStats();

    public boolean hasCapturedFinalDetail() {
        return this.hasCapturedFinalDetail;
    }
}

