/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.management.state.ClientState;
import cascading.stats.ProvidesCounters;
import cascading.stats.StatsListener;
import cascading.util.ProcessLogger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CascadingStats<Child>
implements ProvidesCounters,
Serializable {
    public static final String STATS_STORE_INTERVAL = "cascading.stats.store.interval";
    public static final String STATS_COMPLETE_CHILD_DETAILS_BLOCK_DURATION = "cascading.stats.complete_child_details.block.duration";
    private transient String prefixID;
    protected final String name;
    protected final ClientState clientState;
    protected Status status = Status.PENDING;
    protected Set<StatsListener> listeners;
    protected long pendingTime;
    protected long startTime;
    protected long submitTime;
    protected long runTime;
    protected long finishedTime;
    protected Throwable throwable;
    protected String[] throwableTrace;
    protected AtomicLong lastCaptureDetail = new AtomicLong(0L);

    public static void setStatsStoreInterval(Map<Object, Object> properties, long intervalMs) {
        if (intervalMs <= 0L) {
            throw new IllegalArgumentException("interval must be greater than zero, got: " + intervalMs);
        }
        properties.put(STATS_STORE_INTERVAL, Long.toString(intervalMs));
    }

    protected CascadingStats(String name, ClientState clientState) {
        this.name = name;
        this.clientState = clientState;
    }

    public void prepare() {
        this.clientState.startService();
    }

    public void cleanup() {
        this.clientState.stopService();
    }

    public abstract String getID();

    public String getName() {
        return this.name;
    }

    public abstract Type getType();

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String[] getThrowableTrace() {
        return this.throwableTrace;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public boolean isSkipped() {
        return this.status == Status.SKIPPED;
    }

    public boolean isStarted() {
        return this.status == Status.STARTED;
    }

    public boolean isSubmitted() {
        return this.status == Status.SUBMITTED;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isEngaged() {
        return this.isStarted() || this.isSubmitted() || this.isRunning();
    }

    public boolean isSuccessful() {
        return this.status == Status.SUCCESSFUL;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isFinished() {
        return this.status == Status.SUCCESSFUL || this.status == Status.FAILED || this.status == Status.STOPPED || this.status == Status.SKIPPED;
    }

    public Status getStatus() {
        return this.status;
    }

    public void recordStats() {
        this.clientState.recordStats(this);
    }

    public abstract void recordInfo();

    public synchronized void markPending() {
        this.markPendingTime();
        this.fireListeners(null, Status.PENDING);
        this.recordStats();
        this.recordInfo();
    }

    protected void markPendingTime() {
        if (this.pendingTime == 0L) {
            this.pendingTime = System.currentTimeMillis();
        }
    }

    public synchronized void markStartedThenRunning() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STARTED) + ", is already " + (Object)((Object)this.status));
        }
        this.markStartToRunTime();
        this.markStarted();
        this.markRunning();
    }

    protected void markStartToRunTime() {
        this.submitTime = this.runTime = System.currentTimeMillis();
        this.startTime = this.runTime;
    }

    public synchronized void markStarted() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STARTED) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.STARTED;
        this.markStartTime();
        this.fireListeners(priorStatus, this.status);
        this.clientState.start(this.startTime);
        this.clientState.setStatus(this.status, this.startTime);
        this.recordStats();
        this.recordInfo();
    }

    protected void markStartTime() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public synchronized void markSubmitted() {
        if (this.status == Status.SUBMITTED) {
            return;
        }
        if (this.status != Status.STARTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SUBMITTED) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.SUBMITTED;
        this.markSubmitTime();
        this.fireListeners(priorStatus, this.status);
        this.clientState.submit(this.submitTime);
        this.clientState.setStatus(this.status, this.submitTime);
        this.recordStats();
        this.recordInfo();
    }

    protected void markSubmitTime() {
        if (this.submitTime == 0L) {
            this.submitTime = System.currentTimeMillis();
        }
    }

    public synchronized void markRunning() {
        if (this.status == Status.RUNNING) {
            return;
        }
        if (this.status != Status.STARTED && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.RUNNING) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.RUNNING;
        this.markRunTime();
        this.fireListeners(priorStatus, this.status);
        this.clientState.run(this.runTime);
        this.clientState.setStatus(this.status, this.runTime);
        this.recordStats();
        this.recordInfo();
    }

    protected void markRunTime() {
        if (this.runTime == 0L) {
            this.runTime = System.currentTimeMillis();
        }
    }

    public synchronized void markSuccessful() {
        if (this.status != Status.RUNNING && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SUCCESSFUL) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.SUCCESSFUL;
        this.markFinishedTime();
        this.fireListeners(priorStatus, this.status);
        this.clientState.setStatus(this.status, this.finishedTime);
        this.clientState.stop(this.finishedTime);
        this.recordStats();
        this.recordInfo();
    }

    protected void markFinishedTime() {
        this.finishedTime = System.currentTimeMillis();
    }

    public void markFailed() {
        this.markFailed(null, null);
    }

    public synchronized void markFailed(Throwable throwable) {
        this.markFailed(throwable, null);
    }

    public synchronized void markFailed(String[] throwableTrace) {
        this.markFailed(null, throwableTrace);
    }

    protected synchronized void markFailed(Throwable throwable, String[] throwableTrace) {
        if (this.status != Status.STARTED && this.status != Status.RUNNING && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.FAILED) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.FAILED;
        this.markFinishedTime();
        this.throwable = throwable;
        this.throwableTrace = throwableTrace;
        this.fireListeners(priorStatus, this.status);
        this.clientState.setStatus(this.status, this.finishedTime);
        this.clientState.stop(this.finishedTime);
        this.recordStats();
        this.recordInfo();
    }

    public synchronized void markStopped() {
        if (this.status != Status.PENDING && this.status != Status.STARTED && this.status != Status.SUBMITTED && this.status != Status.RUNNING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STOPPED) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.STOPPED;
        this.markFinishedTime();
        this.fireListeners(priorStatus, this.status);
        this.clientState.setStatus(this.status, this.finishedTime);
        this.recordStats();
        this.recordInfo();
        this.clientState.stop(this.finishedTime);
    }

    public synchronized void markSkipped() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SKIPPED) + ", is already " + (Object)((Object)this.status));
        }
        Status priorStatus = this.status;
        this.status = Status.SKIPPED;
        this.fireListeners(priorStatus, this.status);
        this.clientState.setStatus(this.status, System.currentTimeMillis());
        this.recordStats();
        this.recordInfo();
    }

    public long getPendingTime() {
        return this.pendingTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public long getDuration() {
        if (this.finishedTime != 0L) {
            return this.finishedTime - this.startTime;
        }
        return 0L;
    }

    public long getCurrentDuration() {
        if (this.finishedTime != 0L) {
            return this.finishedTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public Collection<String> getCountersFor(Class<? extends Enum> group) {
        return this.getCountersFor(group.getName());
    }

    public abstract Collection<String> getCounterGroupsMatching(String var1);

    public void captureDetail() {
        this.captureDetail(Type.ATTEMPT);
    }

    public abstract void captureDetail(Type var1);

    protected boolean isDetailStale() {
        return System.currentTimeMillis() - this.lastCaptureDetail.get() > 500L;
    }

    protected void markDetailCaptured() {
        this.lastCaptureDetail.set(System.currentTimeMillis());
    }

    public abstract Collection<Child> getChildren();

    public abstract Child getChildWith(String var1);

    public synchronized void addListener(StatsListener statsListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedHashSet<StatsListener>();
        }
        this.listeners.add(statsListener);
    }

    public synchronized boolean removeListener(StatsListener statsListener) {
        return this.listeners != null && this.listeners.remove(statsListener);
    }

    protected synchronized void fireListeners(Status fromStatus, Status toStatus) {
        if (this.listeners == null) {
            return;
        }
        for (StatsListener listener : this.listeners) {
            try {
                listener.notify(this, fromStatus, toStatus);
            }
            catch (Throwable throwable) {
                this.logWarn("error during listener notification, continuing with remaining listener notification", throwable);
            }
        }
    }

    protected abstract ProcessLogger getProcessLogger();

    protected String getStatsString() {
        String string = "status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime;
        if (this.finishedTime != 0L) {
            string = string + ", duration=" + (this.finishedTime - this.startTime);
        }
        return string;
    }

    public String toString() {
        return "Cascading{" + this.getStatsString() + '}';
    }

    protected void logInfo(String message, Object ... arguments) {
        this.getProcessLogger().logInfo(this.getPrefix() + message, arguments);
    }

    protected void logDebug(String message, Object ... arguments) {
        this.getProcessLogger().logDebug(this.getPrefix() + message, arguments);
    }

    protected void logWarn(String message, Object ... arguments) {
        this.getProcessLogger().logWarn(this.getPrefix() + message, arguments);
    }

    protected void logError(String message, Object ... arguments) {
        this.getProcessLogger().logError(this.getPrefix() + message, arguments);
    }

    protected void logError(String message, Throwable throwable) {
        this.getProcessLogger().logError(this.getPrefix() + message, throwable);
    }

    protected String getPrefix() {
        if (this.prefixID == null) {
            this.prefixID = "[" + this.getType().name().toLowerCase() + ":" + this.getID().substring(0, 5) + "] ";
        }
        return this.prefixID;
    }

    public static enum Status {
        PENDING(false),
        SKIPPED(true),
        STARTED(false),
        SUBMITTED(false),
        RUNNING(false),
        SUCCESSFUL(true),
        STOPPED(true),
        FAILED(true);

        boolean isFinished = false;

        private Status(boolean isFinished) {
            this.isFinished = isFinished;
        }

        public boolean isFinished() {
            return this.isFinished;
        }
    }

    public static enum Type {
        CASCADE,
        FLOW,
        STEP,
        NODE,
        SLICE,
        ATTEMPT;


        public boolean isChild(Type type) {
            return this.ordinal() < type.ordinal();
        }
    }
}

