/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.cascade.Cascade;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.FlowStats;
import cascading.util.ProcessLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class CascadeStats
extends CascadingStats<FlowStats> {
    private Cascade cascade;
    final Map<String, FlowStats> flowStatsMap = new LinkedHashMap<String, FlowStats>();

    public CascadeStats(Cascade cascade, ClientState clientState) {
        super(cascade.getName(), clientState);
        this.cascade = cascade;
    }

    @Override
    protected ProcessLogger getProcessLogger() {
        if (this.cascade != null && this.cascade instanceof ProcessLogger) {
            return (ProcessLogger)((Object)this.cascade);
        }
        return ProcessLogger.NULL;
    }

    @Override
    public String getID() {
        return this.cascade.getID();
    }

    @Override
    public CascadingStats.Type getType() {
        return CascadingStats.Type.CASCADE;
    }

    public Cascade getCascade() {
        return this.cascade;
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordCascade(this.cascade);
    }

    public void addFlowStats(FlowStats flowStats) {
        this.flowStatsMap.put(flowStats.getID(), flowStats);
    }

    public int getFlowCount() {
        return this.flowStatsMap.size();
    }

    @Override
    public long getLastSuccessfulCounterFetchTime() {
        long max = -1L;
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            max = Math.max(max, flowStats.getLastSuccessfulCounterFetchTime());
        }
        return max;
    }

    @Override
    public Collection<String> getCounterGroups() {
        HashSet<String> results = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            results.addAll(flowStats.getCounterGroups());
        }
        return results;
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        HashSet<String> results = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            results.addAll(flowStats.getCounterGroupsMatching(regex));
        }
        return results;
    }

    @Override
    public Collection<String> getCountersFor(String group) {
        HashSet<String> results = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            results.addAll(flowStats.getCountersFor(group));
        }
        return results;
    }

    @Override
    public long getCounterValue(Enum counter) {
        long value = 0L;
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            value += flowStats.getCounterValue(counter);
        }
        return value;
    }

    @Override
    public long getCounterValue(String group, String counter) {
        long value = 0L;
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            value += flowStats.getCounterValue(group, counter);
        }
        return value;
    }

    @Override
    public void captureDetail(CascadingStats.Type depth) {
        if (!this.getType().isChild(depth)) {
            return;
        }
        for (FlowStats flowStats : this.flowStatsMap.values()) {
            flowStats.captureDetail(depth);
        }
    }

    @Override
    public Collection<FlowStats> getChildren() {
        return this.flowStatsMap.values();
    }

    @Override
    public FlowStats getChildWith(String id) {
        return this.flowStatsMap.get(id);
    }

    @Override
    public String toString() {
        return "Cascade{flowStatsList=" + this.flowStatsMap.values() + '}';
    }
}

