/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.CounterCache;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowStepStats;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCachedStepStats<Configuration, JobStatusClient, Counters>
extends FlowStepStats {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCachedStepStats.class);
    protected CounterCache<Configuration, JobStatusClient, Counters> counterCache;

    public BaseCachedStepStats(FlowStep flowStep, ClientState clientState) {
        super(flowStep, clientState);
    }

    public abstract JobStatusClient getJobStatusClient();

    @Override
    public long getLastSuccessfulCounterFetchTime() {
        if (this.counterCache != null) {
            return this.counterCache.getLastSuccessfulFetch();
        }
        return -1L;
    }

    @Override
    public Collection<String> getCounterGroups() {
        return this.counterCache.getCounterGroups();
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        return this.counterCache.getCounterGroupsMatching(regex);
    }

    @Override
    public Collection<String> getCountersFor(String group) {
        return this.counterCache.getCountersFor(group);
    }

    @Override
    public long getCounterValue(Enum counter) {
        return this.counterCache.getCounterValue(counter);
    }

    @Override
    public long getCounterValue(String group, String counter) {
        return this.counterCache.getCounterValue(group, counter);
    }

    protected synchronized Counters cachedCounters(boolean force) {
        return this.counterCache.cachedCounters(force);
    }

    @Override
    public synchronized void recordChildStats() {
        try {
            this.cachedCounters(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.clientState.isEnabled()) {
            return;
        }
        this.captureDetail(CascadingStats.Type.ATTEMPT);
        try {
            for (Map.Entry<String, FlowNodeStats> entry : this.getFlowNodeStatsMap().entrySet()) {
                entry.getValue().recordStats();
                entry.getValue().recordChildStats();
            }
        }
        catch (Exception exception) {
            LOG.error("unable to record node stats", (Throwable)exception);
        }
    }
}

