/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.FlowNode;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.CounterCache;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowSliceStats;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseCachedNodeStats<Config, JobStatus, Counters>
extends FlowNodeStats {
    protected final Map<String, FlowSliceStats> sliceStatsMap = new LinkedHashMap<String, FlowSliceStats>();
    protected CounterCache<Config, JobStatus, Counters> counterCache;
    protected boolean allChildrenFinished;

    protected BaseCachedNodeStats(FlowNode flowNode, ClientState clientState) {
        super(flowNode, clientState);
    }

    @Override
    public long getLastSuccessfulCounterFetchTime() {
        if (this.counterCache != null) {
            return this.counterCache.getLastSuccessfulFetch();
        }
        return -1L;
    }

    public boolean isAllChildrenFinished() {
        return this.allChildrenFinished;
    }

    @Override
    public Collection<String> getCounterGroups() {
        return this.counterCache.getCounterGroups();
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        return this.counterCache.getCounterGroupsMatching(regex);
    }

    @Override
    public Collection<String> getCountersFor(String group) {
        return this.counterCache.getCountersFor(group);
    }

    @Override
    public long getCounterValue(Enum counter) {
        return this.counterCache.getCounterValue(counter);
    }

    @Override
    public long getCounterValue(String group, String counter) {
        return this.counterCache.getCounterValue(group, counter);
    }

    protected synchronized Counters cachedCounters(boolean force) {
        return this.counterCache.cachedCounters(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<FlowSliceStats> getChildren() {
        Map<String, FlowSliceStats> map = this.sliceStatsMap;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.sliceStatsMap.values());
        }
    }

    @Override
    public FlowSliceStats getChildWith(String id) {
        return this.sliceStatsMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void captureDetail(CascadingStats.Type depth) {
        boolean finished = this.isFinished();
        if (finished && this.hasCapturedFinalDetail()) {
            return;
        }
        BaseCachedNodeStats baseCachedNodeStats = this;
        synchronized (baseCachedNodeStats) {
            if (!this.getType().isChild(depth) || !this.isDetailStale()) {
                return;
            }
            boolean success = this.captureChildDetailInternal();
            this.markDetailCaptured();
            if (success) {
                this.logDebug("captured remote node statistic details", new Object[0]);
            }
            boolean bl = this.hasCapturedFinalDetail = finished && success && this.allChildrenFinished;
            if (this.allChildrenFinished) {
                this.logInfo("all {} children are in finished state, have captured final details: {}", this.sliceStatsMap.size(), this.hasCapturedFinalDetail());
            }
        }
    }

    protected abstract boolean captureChildDetailInternal();

    @Override
    public synchronized void recordChildStats() {
        try {
            this.cachedCounters(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.clientState.isEnabled()) {
            return;
        }
        this.captureDetail(CascadingStats.Type.ATTEMPT);
        try {
            for (FlowSliceStats value : this.sliceStatsMap.values()) {
                this.clientState.record(value.getID(), value);
            }
        }
        catch (Exception exception) {
            this.logError("unable to record node stats", exception);
        }
    }
}

