/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.util;

import cascading.flow.FlowProcess;
import cascading.scheme.util.FieldTypeResolver;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.ToCanonical;
import cascading.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedParser
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedParser.class);
    static final String SPECIAL_REGEX_CHARS = "([\\]\\[|.*<>\\\\$^?()=!+])";
    static final String QUOTED_REGEX_FORMAT = "%2$s(?=(?:[^%1$s]*%1$s[^%1$s]*[^%1$s%2$s]*%1$s)*(?![^%1$s]*%1$s))";
    static final String CLEAN_REGEX_FORMAT = "^(?:%1$s)(.*)(?:%1$s)$";
    static final String ESCAPE_REGEX_FORMAT = "(%1$s%1$s)";
    protected Fields sourceFields;
    protected Pattern splitPattern;
    protected Pattern cleanPattern;
    protected Pattern escapePattern;
    protected String delimiter;
    protected String quote;
    protected boolean strict = true;
    protected boolean enforceStrict = true;
    protected int numValues;
    protected Type[] types;
    protected ToCanonical<String, ?>[] canonicals;
    protected boolean safe = true;
    protected FieldTypeResolver fieldTypeResolver;

    public DelimitedParser(String delimiter, String quote, Class[] types) {
        this.reset(delimiter, quote, types, this.strict, this.safe, null, null, null);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types, boolean strict, boolean safe) {
        this.reset(delimiter, quote, types, strict, safe, null, null, null);
    }

    public DelimitedParser(String delimiter, String quote, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, null, this.strict, this.safe, null, null, fieldTypeResolver);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types, boolean strict, boolean safe, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, types, strict, safe, null, null, fieldTypeResolver);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types, boolean strict, boolean safe, Fields sourceFields, Fields sinkFields) {
        this.reset(delimiter, quote, types, strict, safe, sourceFields, sinkFields, null);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types, boolean strict, boolean safe, Fields sourceFields, Fields sinkFields, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, types, strict, safe, sourceFields, sinkFields, fieldTypeResolver);
    }

    public void reset(Fields sourceFields, Fields sinkFields) {
        this.reset(this.delimiter, this.quote, this.types, this.strict, this.safe, sourceFields, sinkFields, this.fieldTypeResolver);
    }

    public void reset(String delimiter, String quote, Type[] types, boolean strict, boolean safe, Fields sourceFields, Fields sinkFields, FieldTypeResolver fieldTypeResolver) {
        if (delimiter == null || delimiter.isEmpty()) {
            throw new IllegalArgumentException("delimiter may not be null or empty");
        }
        if (delimiter.equals(quote)) {
            throw new IllegalArgumentException("delimiter and quote character may not be the same value, got: '" + delimiter + "'");
        }
        this.delimiter = delimiter;
        this.strict = strict;
        this.safe = safe;
        this.fieldTypeResolver = fieldTypeResolver;
        if (quote != null && !quote.isEmpty()) {
            this.quote = quote;
        }
        if (types != null && types.length == 0) {
            this.types = null;
        }
        if (types != null) {
            this.types = Arrays.copyOf(types, types.length);
        }
        if (sourceFields == null || sinkFields == null) {
            return;
        }
        if (types == null && sourceFields.hasTypes()) {
            this.types = sourceFields.getTypes();
        }
        this.sourceFields = sourceFields;
        this.numValues = Math.max(sourceFields.size(), sinkFields.size());
        this.enforceStrict = this.strict;
        if (sourceFields.isUnknown()) {
            this.enforceStrict = false;
        }
        if (!sinkFields.isAll() && this.numValues == 0) {
            throw new IllegalArgumentException("may not be zero declared fields, found: " + sinkFields.printVerbose());
        }
        this.splitPattern = this.createSplitPatternFor(this.delimiter, this.quote);
        this.cleanPattern = this.createCleanPatternFor(this.quote);
        this.escapePattern = this.createEscapePatternFor(this.quote);
        if (this.types != null && sinkFields.isAll()) {
            throw new IllegalArgumentException("when using Fields.ALL, field types may not be used");
        }
        if (this.types != null && this.types.length != sinkFields.size()) {
            throw new IllegalArgumentException("num of types must equal number of fields: " + sinkFields.printVerbose() + ", found: " + this.types.length);
        }
        this.canonicals = Coercions.canonicalArray(String.class, this.numValues, this.types);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getQuote() {
        return this.quote;
    }

    public Pattern createEscapePatternFor(String quote) {
        if (quote == null || quote.isEmpty()) {
            return null;
        }
        return Pattern.compile(String.format(ESCAPE_REGEX_FORMAT, quote));
    }

    public Pattern createCleanPatternFor(String quote) {
        if (quote == null || quote.isEmpty()) {
            return null;
        }
        return Pattern.compile(String.format(CLEAN_REGEX_FORMAT, quote));
    }

    public Pattern createSplitPatternFor(String delimiter, String quote) {
        String escapedDelimiter = delimiter.replaceAll(SPECIAL_REGEX_CHARS, "\\\\$1");
        if (quote == null || quote.isEmpty()) {
            return Pattern.compile(escapedDelimiter);
        }
        return Pattern.compile(String.format(QUOTED_REGEX_FORMAT, quote, escapedDelimiter));
    }

    public String[] createSplit(String value, Pattern splitPattern, int numValues) {
        return splitPattern.split(value, numValues);
    }

    public String[] cleanSplit(String[] split, Pattern cleanPattern, Pattern escapePattern, String quote) {
        int i;
        if (cleanPattern != null) {
            for (i = 0; i < split.length; ++i) {
                split[i] = cleanPattern.matcher(split[i]).replaceAll("$1");
                split[i] = escapePattern.matcher(split[i]).replaceAll(quote);
            }
        }
        for (i = 0; i < split.length; ++i) {
            if (!split[i].isEmpty()) continue;
            split[i] = null;
        }
        return split;
    }

    public Fields parseFirstLine(FlowProcess flowProcess, Tap tap) {
        Fields sourceFields;
        Closeable iterator = null;
        try {
            TupleEntry entry;
            if (!tap.resourceExists(flowProcess)) {
                throw new TapException("unable to read fields from tap: " + tap + ", does not exist");
            }
            iterator = tap.openForRead(flowProcess);
            TupleEntry tupleEntry = entry = iterator.hasNext() ? (TupleEntry)iterator.next() : null;
            if (entry == null) {
                throw new TapException("unable to read fields from tap: " + tap + ", is empty");
            }
            Object[] result = this.onlyParseLine(entry.getTuple().getString(0));
            result = this.cleanParsedLine((String[])result);
            Type[] inferred = this.inferTypes(result);
            result = this.cleanFields((String[])result);
            sourceFields = new Fields((Comparable[])Arrays.copyOf(result, result.length, Comparable[].class));
            if (inferred != null) {
                sourceFields = sourceFields.applyTypes(inferred);
            }
        }
        catch (IOException exception) {
            throw new TapException("unable to read fields from tap: " + tap, exception);
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sourceFields;
    }

    public Object[] parseLine(String line) {
        String[] split = this.onlyParseLine(line);
        split = this.cleanParsedLine(split);
        return this.coerceParsedLine(line, split);
    }

    protected String[] cleanParsedLine(String[] split) {
        return this.cleanSplit(split, this.cleanPattern, this.escapePattern, this.quote);
    }

    protected Object[] coerceParsedLine(String line, String[] split) {
        if (this.types == null) {
            return split;
        }
        Object[] result = new Object[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                result[i] = this.canonicals[i].canonical(split[i]);
                continue;
            }
            catch (Exception exception) {
                result[i] = null;
                if (!this.safe) {
                    throw new TapException(this.getSafeMessage(split[i], i), exception, new Tuple(line));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(this.getSafeMessage(split[i], i), (Throwable)exception);
            }
        }
        return result;
    }

    private String getSafeMessage(Object object, int i) {
        try {
            return "field " + this.sourceFields.get(i) + " cannot be coerced from : " + object + " to: " + Util.getTypeName(this.types[i]);
        }
        catch (Throwable throwable) {
            return "field pos " + i + " cannot be coerced from: " + object + ", pos has no corresponding field name or coercion type";
        }
    }

    protected String[] onlyParseLine(String line) {
        Object[] split = this.createSplit(line, this.splitPattern, this.numValues == 0 ? 0 : -1);
        if (this.numValues != 0 && split.length != this.numValues) {
            if (this.enforceStrict) {
                throw new TapException(this.getParseMessage(split), new Tuple(line));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getParseMessage(split));
            }
            Object[] array = new String[this.numValues];
            Arrays.fill(array, "");
            System.arraycopy(split, 0, array, 0, Math.min(this.numValues, split.length));
            split = array;
        }
        return split;
    }

    private String getParseMessage(Object[] split) {
        return "did not parse correct number of values from input data, expected: " + this.numValues + ", got: " + split.length + ":" + Util.join(",", (String[])split);
    }

    public Appendable joinFirstLine(Iterable iterable, Appendable buffer) {
        iterable = this.prepareFields(iterable);
        return this.joinLine(iterable, buffer);
    }

    public Appendable joinLine(Iterable iterable, Appendable buffer) {
        try {
            if (this.quote != null) {
                return this.joinWithQuote(iterable, buffer);
            }
            return this.joinNoQuote(iterable, buffer);
        }
        catch (IOException exception) {
            throw new TapException("unable to append data", exception);
        }
    }

    protected Appendable joinWithQuote(Iterable tuple, Appendable buffer) throws IOException {
        int count = 0;
        for (Object value : tuple) {
            if (count != 0) {
                buffer.append(this.delimiter);
            }
            if (value != null) {
                String valueString = value.toString();
                if (valueString.contains(this.quote)) {
                    valueString = valueString.replaceAll(this.quote, this.quote + this.quote);
                }
                if (valueString.contains(this.delimiter)) {
                    valueString = this.quote + valueString + this.quote;
                }
                buffer.append(valueString);
            }
            ++count;
        }
        return buffer;
    }

    protected Appendable joinNoQuote(Iterable tuple, Appendable buffer) throws IOException {
        int count = 0;
        for (Object value : tuple) {
            if (count != 0) {
                buffer.append(this.delimiter);
            }
            if (value != null) {
                buffer.append(value.toString());
            }
            ++count;
        }
        return buffer;
    }

    protected Type[] inferTypes(Object[] result) {
        if (this.fieldTypeResolver == null) {
            return null;
        }
        Type[] inferred = new Type[result.length];
        for (int i = 0; i < result.length; ++i) {
            String field = (String)result[i];
            inferred[i] = this.fieldTypeResolver.inferTypeFrom(i, field);
        }
        return inferred;
    }

    protected Iterable prepareFields(Iterable fields) {
        if (this.fieldTypeResolver == null) {
            return fields;
        }
        ArrayList result = new ArrayList();
        for (Object field : fields) {
            Type type;
            int index = result.size();
            String value = this.fieldTypeResolver.prepareField(index, (String)field, type = this.types != null ? this.types[index] : null);
            if (value != null && !value.isEmpty()) {
                field = value;
            }
            result.add(field);
        }
        return result;
    }

    protected String[] cleanFields(String[] result) {
        if (this.fieldTypeResolver == null) {
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            Type type = this.types != null ? this.types[i] : null;
            String value = this.fieldTypeResolver.cleanField(i, result[i], type);
            if (value == null || value.isEmpty()) continue;
            result[i] = value;
        }
        return result;
    }
}

