/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import java.io.IOException;
import java.io.Serializable;

public abstract class Scheme<Config, Input, Output, SourceContext, SinkContext>
implements Serializable,
Traceable {
    Fields sinkFields = Fields.ALL;
    Fields sourceFields = Fields.UNKNOWN;
    int numSinkParts;
    private String trace = TraceUtil.captureDebugTrace(this);

    protected Scheme() {
    }

    protected Scheme(Fields sourceFields) {
        this.setSourceFields(sourceFields);
    }

    protected Scheme(Fields sourceFields, int numSinkParts) {
        this.setSourceFields(sourceFields);
        this.numSinkParts = numSinkParts;
    }

    protected Scheme(Fields sourceFields, Fields sinkFields) {
        this.setSourceFields(sourceFields);
        this.setSinkFields(sinkFields);
    }

    protected Scheme(Fields sourceFields, Fields sinkFields, int numSinkParts) {
        this.setSourceFields(sourceFields);
        this.setSinkFields(sinkFields);
        this.numSinkParts = numSinkParts;
    }

    public Fields getSinkFields() {
        return this.sinkFields;
    }

    public void setSinkFields(Fields sinkFields) {
        this.sinkFields = sinkFields.isUnknown() ? Fields.ALL : sinkFields;
    }

    public Fields getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(Fields sourceFields) {
        this.sourceFields = sourceFields.isAll() ? Fields.UNKNOWN : sourceFields;
    }

    public int getNumSinkParts() {
        return this.numSinkParts;
    }

    public void setNumSinkParts(int numSinkParts) {
        this.numSinkParts = numSinkParts;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public boolean isSymmetrical() {
        return this.getSourceFields().equals(Fields.UNKNOWN) && this.getSinkFields().equals(Fields.ALL) || this.getSinkFields().equals(this.getSourceFields());
    }

    public boolean isSource() {
        return true;
    }

    public boolean isSink() {
        return true;
    }

    public Fields retrieveSourceFields(FlowProcess<? extends Config> flowProcess, Tap tap) {
        return this.getSourceFields();
    }

    public void presentSourceFields(FlowProcess<? extends Config> flowProcess, Tap tap, Fields fields) {
        this.presentSourceFieldsInternal(fields);
    }

    protected void presentSourceFieldsInternal(Fields fields) {
        if (this.getSourceFields().equals(Fields.UNKNOWN)) {
            this.setSourceFields(fields);
        }
    }

    public Fields retrieveSinkFields(FlowProcess<? extends Config> flowProcess, Tap tap) {
        return this.getSinkFields();
    }

    public void presentSinkFields(FlowProcess<? extends Config> flowProcess, Tap tap, Fields fields) {
        this.presentSinkFieldsInternal(fields);
    }

    protected void presentSinkFieldsInternal(Fields fields) {
        if (this.getSinkFields().equals(Fields.ALL)) {
            this.setSinkFields(fields);
        }
    }

    public abstract void sourceConfInit(FlowProcess<? extends Config> var1, Tap<Config, Input, Output> var2, Config var3);

    public abstract void sinkConfInit(FlowProcess<? extends Config> var1, Tap<Config, Input, Output> var2, Config var3);

    public Input sourceWrap(FlowProcess<? extends Config> flowProcess, Input input) throws IOException {
        return input;
    }

    public void sourcePrepare(FlowProcess<? extends Config> flowProcess, SourceCall<SourceContext, Input> sourceCall) throws IOException {
    }

    public void sourceRePrepare(FlowProcess<? extends Config> flowProcess, SourceCall<SourceContext, Input> sourceCall) throws IOException {
    }

    public abstract boolean source(FlowProcess<? extends Config> var1, SourceCall<SourceContext, Input> var2) throws IOException;

    public void sourceCleanup(FlowProcess<? extends Config> flowProcess, SourceCall<SourceContext, Input> sourceCall) throws IOException {
    }

    public Output sinkWrap(FlowProcess<? extends Config> flowProcess, Output output) throws IOException {
        return output;
    }

    public void sinkPrepare(FlowProcess<? extends Config> flowProcess, SinkCall<SinkContext, Output> sinkCall) throws IOException {
    }

    public abstract void sink(FlowProcess<? extends Config> var1, SinkCall<SinkContext, Output> var2) throws IOException;

    public void sinkCleanup(FlowProcess<? extends Config> flowProcess, SinkCall<SinkContext, Output> sinkCall) throws IOException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)object;
        if (this.numSinkParts != scheme.numSinkParts) {
            return false;
        }
        if (this.sinkFields != null ? !this.sinkFields.equals(scheme.sinkFields) : scheme.sinkFields != null) {
            return false;
        }
        return !(this.sourceFields != null ? !this.sourceFields.equals(scheme.sourceFields) : scheme.sourceFields != null);
    }

    public String toString() {
        if (this.getSinkFields().equals(this.getSourceFields())) {
            return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "->" + this.getSinkFields().print() + "]";
    }

    public int hashCode() {
        int result = this.sinkFields != null ? this.sinkFields.hashCode() : 0;
        result = 31 * result + (this.sourceFields != null ? this.sourceFields.hashCode() : 0);
        result = 31 * result + this.numSinkParts;
        return result;
    }
}

