/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.util.Util;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkDef<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkDef.class);
    protected String name;
    protected Set<String> tags = new TreeSet<String>();

    public UnitOfWorkDef() {
    }

    protected UnitOfWorkDef(UnitOfWorkDef<T> unitOfWorkDef) {
        this.name = unitOfWorkDef.name;
        this.tags.addAll(unitOfWorkDef.tags);
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public String getTags() {
        return Util.join(this.tags, ",");
    }

    public T addTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return (T)this;
        }
        if (Util.containsWhitespace(tag = tag.trim())) {
            LOG.warn("tags should not contain whitespace characters: '{}'", (Object)tag);
        }
        this.tags.add(tag);
        return (T)this;
    }

    public T addTags(String ... tags) {
        for (String tag : tags) {
            this.addTag(tag);
        }
        return (T)this;
    }
}

