/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.flow.planner.ScopedElement;
import cascading.property.ConfigDef;
import cascading.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class PropertyUtil {
    public static String getProperty(Map<Object, Object> properties, String property) {
        return PropertyUtil.getProperty(properties, property, (String)null);
    }

    public static boolean getBooleanProperty(Map<Object, Object> properties, String property, boolean defaultValue) {
        return PropertyUtil.getBooleanProperty(System.getProperties(), properties, property, defaultValue);
    }

    public static boolean getBooleanProperty(Properties defaultProperties, Map<Object, Object> properties, String property, boolean defaultValue) {
        String result = defaultProperties == null ? PropertyUtil.getProperty(properties, property) : PropertyUtil.getProperty(properties, property, defaultProperties.getProperty(property));
        if (Util.isEmpty(result)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(result);
    }

    public static int getIntProperty(Map<Object, Object> properties, String property, int defaultValue) {
        return PropertyUtil.getIntProperty(System.getProperties(), properties, property, defaultValue);
    }

    public static int getIntProperty(Properties defaultProperties, Map<Object, Object> properties, String property, int defaultValue) {
        String result = defaultProperties == null ? PropertyUtil.getProperty(properties, property) : PropertyUtil.getProperty(properties, property, defaultProperties.getProperty(property));
        if (Util.isEmpty(result)) {
            return defaultValue;
        }
        return Integer.parseInt(result);
    }

    public static String getStringProperty(Map<Object, Object> properties, String property) {
        return PropertyUtil.getStringProperty(System.getProperties(), properties, property);
    }

    public static String getStringProperty(Properties defaultProperties, Map<Object, Object> properties, String property) {
        if (defaultProperties == null) {
            return PropertyUtil.getProperty(properties, property);
        }
        return PropertyUtil.getProperty(properties, property, defaultProperties.getProperty(property));
    }

    public static <A> A getProperty(Map<Object, Object> properties, String key, A defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Object value = properties instanceof Properties ? ((Properties)properties).getProperty(key) : properties.get(key);
        return (A)(value == null ? defaultValue : value);
    }

    public static String getProperty(Map<Object, Object> properties, ScopedElement flowElement, String property) {
        if (flowElement != null && flowElement.hasConfigDef()) {
            return PropertyUtil.getProperty(properties, flowElement.getConfigDef(), property);
        }
        return PropertyUtil.getProperty(properties, property);
    }

    public static String getProperty(final Map<Object, Object> properties, ConfigDef configDef, String property) {
        return configDef.apply(property, new ConfigDef.Getter(){

            @Override
            public String update(String key, String value) {
                return value;
            }

            @Override
            public String get(String key) {
                return PropertyUtil.getProperty(properties, key);
            }
        });
    }

    public static void setProperty(Map<Object, Object> properties, String key, String value) {
        if (properties == null || value == null || value.isEmpty()) {
            return;
        }
        if (properties instanceof Properties) {
            ((Properties)properties).setProperty(key, value);
        } else {
            properties.put(key, value);
        }
    }

    public static Properties createProperties(Iterable<Map.Entry<String, String>> defaultProperties) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> property : defaultProperties) {
            properties.setProperty(property.getKey(), property.getValue());
        }
        return properties;
    }

    public static Properties createProperties(Map<Object, Object> properties, Properties defaultProperties) {
        Properties results;
        Properties properties2 = results = defaultProperties == null ? new Properties() : new Properties(defaultProperties);
        if (properties == null) {
            return results;
        }
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys) {
            Object value = properties.get(e);
            if (value == null && properties instanceof Properties && e instanceof String) {
                value = ((Properties)properties).getProperty((String)e);
            }
            if (value == null || value instanceof Class) continue;
            results.setProperty(e.toString(), value.toString());
        }
        return results;
    }

    public static Map<Object, Object> asFlatMap(Map<Object, Object> properties) {
        if (!(properties instanceof Properties)) {
            return properties;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Properties props = (Properties)properties;
        for (String property : props.stringPropertyNames()) {
            map.put(property, props.getProperty(property));
        }
        return map;
    }

    public static Properties merge(Properties ... properties) {
        Properties results = new Properties();
        for (int i = properties.length - 1; i >= 0; --i) {
            Properties current = properties[i];
            if (current == null) continue;
            Set<String> currentNames = current.stringPropertyNames();
            for (String currentName : currentNames) {
                results.setProperty(currentName, current.getProperty(currentName));
            }
        }
        return results;
    }

    public static Properties remove(Properties properties, Properties ... remove) {
        Objects.requireNonNull(properties, "properties may not be null");
        HashSet<String> keys = new HashSet<String>();
        for (Properties current : remove) {
            keys.addAll(current.stringPropertyNames());
        }
        return PropertyUtil.remove(properties, keys);
    }

    public static Properties remove(Properties properties, Set<String> keys) {
        Objects.requireNonNull(properties, "properties may not be null");
        Properties results = new Properties();
        for (String name : properties.stringPropertyNames()) {
            if (keys.contains(name)) continue;
            results.setProperty(name, properties.getProperty(name));
        }
        return results;
    }

    public static Properties retain(Properties properties, Properties ... retain) {
        Objects.requireNonNull(properties, "properties may not be null");
        HashSet<String> keys = new HashSet<String>();
        for (Properties current : retain) {
            if (current == null) continue;
            keys.addAll(current.stringPropertyNames());
        }
        return PropertyUtil.remove(properties, keys);
    }

    public static Properties retain(Properties properties, Set<String> keys) {
        Objects.requireNonNull(properties, "properties may not be null");
        Properties results = new Properties();
        for (String name : properties.stringPropertyNames()) {
            if (!keys.contains(name)) continue;
            results.setProperty(name, properties.getProperty(name));
        }
        return results;
    }
}

