/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.property.PropertyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class ConfigDef
implements Serializable {
    protected Map<Mode, Map<String, String>> config;

    public ConfigDef setProperty(String key, String value) {
        return this.setProperty(Mode.REPLACE, key, value);
    }

    public ConfigDef setProperty(Mode mode, String key, String value) {
        this.getMode(mode).put(key, value);
        return this;
    }

    public ConfigDef setAllProperties(Mode mode, Properties ... properties) {
        Map<String, String> map = this.getMode(mode);
        Properties merged = PropertyUtil.merge(properties);
        for (String property : merged.stringPropertyNames()) {
            map.put(property, merged.getProperty(property));
        }
        return this;
    }

    protected Map<String, String> getMode(Mode mode) {
        if (this.config == null) {
            this.config = new HashMap<Mode, Map<String, String>>();
        }
        if (!this.config.containsKey((Object)mode)) {
            this.config.put(mode, new HashMap());
        }
        return this.config.get((Object)mode);
    }

    protected Map<String, String> getModeSafe(Mode mode) {
        if (this.config == null) {
            return Collections.emptyMap();
        }
        if (!this.config.containsKey((Object)mode)) {
            return Collections.emptyMap();
        }
        return this.config.get((Object)mode);
    }

    public boolean isEmpty() {
        return this.config == null || this.config.isEmpty();
    }

    public String apply(String key, Getter getter) {
        String defaultValue = this.getModeSafe(Mode.DEFAULT).get(key);
        String replaceValue = this.getModeSafe(Mode.REPLACE).get(key);
        String updateValue = this.getModeSafe(Mode.UPDATE).get(key);
        String currentValue = getter.get(key);
        if (currentValue == null && replaceValue == null && updateValue == null) {
            return defaultValue;
        }
        if (replaceValue != null) {
            return replaceValue;
        }
        if (updateValue == null) {
            return currentValue;
        }
        if (currentValue == null) {
            return updateValue;
        }
        return getter.update(key, updateValue);
    }

    public void apply(Mode mode, Setter setter) {
        if (!this.config.containsKey((Object)mode)) {
            return;
        }
        for (String key : this.config.get((Object)mode).keySet()) {
            switch (mode) {
                case DEFAULT: {
                    if (setter.get(key) != null) break;
                    setter.set(key, this.config.get((Object)mode).get(key));
                    break;
                }
                case REPLACE: {
                    setter.set(key, this.config.get((Object)mode).get(key));
                    break;
                }
                case UPDATE: {
                    setter.update(key, this.config.get((Object)mode).get(key));
                }
            }
        }
    }

    public Collection<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, String> map : this.config.values()) {
            keys.addAll(map.keySet());
        }
        return Collections.unmodifiableSet(keys);
    }

    public static interface Getter {
        public String update(String var1, String var2);

        public String get(String var1);
    }

    public static interface Setter {
        public String set(String var1, String var2);

        public String update(String var1, String var2);

        public String get(String var1);
    }

    public static enum Mode {
        DEFAULT,
        REPLACE,
        UPDATE;

    }
}

