/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.property.PropertyUtil;
import cascading.property.Props;
import cascading.util.Util;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProps
extends Props {
    private static final Logger LOG = LoggerFactory.getLogger(AppProps.class);
    public static final String APP_ID = "cascading.app.id";
    public static final String APP_NAME = "cascading.app.name";
    public static final String APP_VERSION = "cascading.app.version";
    public static final String APP_TAGS = "cascading.app.tags";
    public static final String APP_FRAMEWORKS = "cascading.app.frameworks";
    public static final String APP_JAR_CLASS = "cascading.app.appjar.class";
    public static final String APP_JAR_PATH = "cascading.app.appjar.path";
    static final String DEP_APP_JAR_CLASS = "cascading.flowconnector.appjar.class";
    static final String DEP_APP_JAR_PATH = "cascading.flowconnector.appjar.path";
    private static String appID;
    protected String name;
    protected String version;
    protected Set<String> tags = new TreeSet<String>();
    protected Class jarClass;
    protected String jarPath;
    protected Set<String> frameworks = new TreeSet<String>();

    public static AppProps appProps() {
        return new AppProps();
    }

    public static void setApplicationJarClass(Map<Object, Object> properties, Class type) {
        if (type != null) {
            PropertyUtil.setProperty(properties, APP_JAR_CLASS, type.getName());
        }
    }

    public static Class<?> getApplicationJarClass(Map<Object, Object> properties) {
        Object type = PropertyUtil.getProperty(properties, DEP_APP_JAR_CLASS, null);
        if (type instanceof Class) {
            LOG.warn("using deprecated property: {}, use instead: {}", (Object)DEP_APP_JAR_CLASS, (Object)APP_JAR_CLASS);
            return type;
        }
        String className = type;
        if (className != null) {
            LOG.warn("using deprecated property: {}, use instead: {}", (Object)DEP_APP_JAR_CLASS, (Object)APP_JAR_CLASS);
            return Util.loadClassSafe(className);
        }
        type = PropertyUtil.getProperty(properties, APP_JAR_CLASS, null);
        if (type instanceof Class) {
            return type;
        }
        className = type;
        if (className == null) {
            return null;
        }
        return Util.loadClassSafe(className);
    }

    public static void setApplicationJarPath(Map<Object, Object> properties, String path) {
        if (path != null) {
            properties.put(APP_JAR_PATH, path);
        }
    }

    public static String getApplicationJarPath(Map<Object, Object> properties) {
        String property = PropertyUtil.getProperty(properties, DEP_APP_JAR_PATH, (String)null);
        if (property != null) {
            LOG.warn("using deprecated property: {}, use instead: {}", (Object)DEP_APP_JAR_PATH, (Object)APP_JAR_PATH);
            return property;
        }
        return PropertyUtil.getProperty(properties, APP_JAR_PATH, (String)null);
    }

    public static void setApplicationID(Map<Object, Object> properties) {
        properties.put(APP_ID, AppProps.getAppID());
    }

    public static String getApplicationID(Map<Object, Object> properties) {
        if (properties == null) {
            return AppProps.getAppID();
        }
        return PropertyUtil.getProperty(properties, APP_ID, AppProps.getAppID());
    }

    public static String getApplicationID() {
        return AppProps.getAppID();
    }

    private static String getAppID() {
        if (appID == null) {
            appID = Util.createUniqueID();
            LOG.info("using app.id: {}", (Object)appID);
        }
        return appID;
    }

    public static void resetAppID() {
        appID = null;
    }

    public static void setApplicationName(Map<Object, Object> properties, String name) {
        if (name != null) {
            properties.put(APP_NAME, name);
        }
    }

    public static String getApplicationName(Map<Object, Object> properties) {
        return PropertyUtil.getProperty(properties, APP_NAME, (String)null);
    }

    public static void setApplicationVersion(Map<Object, Object> properties, String version) {
        if (version != null) {
            properties.put(APP_VERSION, version);
        }
    }

    public static String getApplicationVersion(Map<Object, Object> properties) {
        return PropertyUtil.getProperty(properties, APP_VERSION, (String)null);
    }

    public static void addApplicationTag(Map<Object, Object> properties, String tag) {
        String tags;
        if (tag == null) {
            return;
        }
        if (Util.containsWhitespace(tag = tag.trim())) {
            LOG.warn("tags should not contain whitespace characters: '{}'", (Object)tag);
        }
        tags = (tags = PropertyUtil.getProperty(properties, APP_TAGS, (String)null)) != null ? Util.join(",", tag, tags) : tag;
        properties.put(APP_TAGS, tags);
    }

    public static String getApplicationTags(Map<Object, Object> properties) {
        return PropertyUtil.getProperty(properties, APP_TAGS, (String)null);
    }

    public static void addApplicationFramework(Map<Object, Object> properties, String framework) {
        if (framework == null) {
            return;
        }
        String frameworks = PropertyUtil.getProperty(properties, APP_FRAMEWORKS, System.getProperty(APP_FRAMEWORKS));
        frameworks = frameworks != null ? Util.join(",", framework.trim(), frameworks) : framework;
        frameworks = Util.unique(frameworks, ",");
        if (properties != null) {
            properties.put(APP_FRAMEWORKS, frameworks);
        }
        System.setProperty(APP_FRAMEWORKS, frameworks);
    }

    public static String getApplicationFrameworks(Map<Object, Object> properties) {
        return PropertyUtil.getProperty(properties, APP_FRAMEWORKS, System.getProperty(APP_FRAMEWORKS));
    }

    public AppProps() {
    }

    public AppProps(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public AppProps setName(String name) {
        this.name = name;
        return this;
    }

    public AppProps setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getTags() {
        return Util.join(this.tags, ",");
    }

    public AppProps addTag(String tag) {
        if (!Util.isEmpty(tag)) {
            this.tags.add(tag);
        }
        return this;
    }

    public AppProps addTags(String ... tags) {
        for (String tag : tags) {
            this.addTag(tag);
        }
        return this;
    }

    public String getFrameworks() {
        return Util.join(this.frameworks, ",");
    }

    public AppProps addFramework(String framework) {
        if (!Util.isEmpty(framework)) {
            this.frameworks.add(framework);
        }
        return this;
    }

    public AppProps addFramework(String framework, String version) {
        if (!Util.isEmpty(framework) && !Util.isEmpty(version)) {
            this.frameworks.add(framework + ":" + version);
        }
        if (!Util.isEmpty(framework)) {
            this.frameworks.add(framework);
        }
        return this;
    }

    public AppProps addFrameworks(String ... frameworks) {
        for (String framework : frameworks) {
            this.addFramework(framework);
        }
        return this;
    }

    public AppProps setJarClass(Class jarClass) {
        this.jarClass = jarClass;
        return this;
    }

    public AppProps setJarPath(String jarPath) {
        this.jarPath = jarPath;
        return this;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        AppProps.setApplicationID(properties);
        AppProps.setApplicationName(properties, this.name);
        AppProps.setApplicationVersion(properties, this.version);
        AppProps.addApplicationTag(properties, this.getTags());
        AppProps.addApplicationFramework(properties, this.getFrameworks());
        AppProps.setApplicationJarClass(properties, this.jarClass);
        AppProps.setApplicationJarPath(properties, this.jarPath);
    }
}

