/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.joiner;

import cascading.pipe.joiner.BaseJoiner;
import cascading.pipe.joiner.JoinerClosure;
import cascading.pipe.joiner.OuterJoin;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Iterator;

public class MixedJoin
extends BaseJoiner {
    public static boolean INNER = true;
    public static boolean OUTER = false;
    final boolean[] asInner;

    @ConstructorProperties(value={"asInner"})
    public MixedJoin(boolean[] asInner) {
        this.asInner = Arrays.copyOf(asInner, asInner.length);
    }

    @ConstructorProperties(value={"fieldDeclaration", "asInner"})
    public MixedJoin(Fields fieldDeclaration, boolean[] asInner) {
        super(fieldDeclaration);
        this.asInner = asInner;
    }

    @Override
    public int numJoins() {
        return this.asInner.length - 1;
    }

    @Override
    public Iterator<Tuple> getIterator(JoinerClosure closure) {
        return new JoinIterator(closure);
    }

    public class JoinIterator
    extends OuterJoin.JoinIterator {
        public JoinIterator(JoinerClosure closure) {
            super(closure);
        }

        @Override
        protected boolean isOuter(int i) {
            return !MixedJoin.this.asInner[i] && super.isOuter(i);
        }
    }
}

