/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.joiner;

import cascading.flow.FlowProcess;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.util.Arrays;
import java.util.Iterator;

public abstract class JoinerClosure {
    protected final FlowProcess flowProcess;
    protected final Fields[] joinFields;
    protected final Fields[] valueFields;

    public JoinerClosure(FlowProcess flowProcess, Fields[] joinFields, Fields[] valueFields) {
        this.flowProcess = flowProcess;
        this.joinFields = Arrays.copyOf(joinFields, joinFields.length);
        this.valueFields = Arrays.copyOf(valueFields, valueFields.length);
    }

    public FlowProcess getFlowProcess() {
        return this.flowProcess;
    }

    public Fields[] getJoinFields() {
        return this.joinFields;
    }

    public Fields[] getValueFields() {
        return this.valueFields;
    }

    public boolean isSelfJoin() {
        return this.valueFields.length == 1 && this.size() != this.valueFields.length;
    }

    public abstract int size();

    public abstract Iterator<Tuple> getIterator(int var1);

    public abstract boolean isEmpty(int var1);

    public abstract Tuple getGroupTuple(Tuple var1);
}

