/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.joiner;

import cascading.pipe.joiner.BaseJoiner;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.util.TupleViews;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerJoin
extends BaseJoiner {
    private static final Logger LOG = LoggerFactory.getLogger(InnerJoin.class);

    public InnerJoin() {
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public InnerJoin(Fields fieldDeclaration) {
        super(fieldDeclaration);
    }

    @Override
    public Iterator<Tuple> getIterator(JoinerClosure closure) {
        return new JoinIterator(closure);
    }

    @Override
    public int numJoins() {
        return -1;
    }

    static interface TupleBuilder {
        public Tuple makeResult(Tuple[] var1);
    }

    public static class JoinIterator
    implements Iterator<Tuple> {
        final JoinerClosure closure;
        Iterator[] iterators;
        Tuple[] lastValues;
        TupleBuilder resultBuilder;
        Tuple result = new Tuple();

        public JoinIterator(JoinerClosure closure) {
            this.closure = closure;
            LOG.debug("cogrouped size: {}", (Object)closure.size());
            this.init();
        }

        protected void init() {
            this.iterators = new Iterator[this.closure.size()];
            for (int i = 0; i < this.closure.size(); ++i) {
                this.iterators[i] = this.getIterator(i);
            }
            boolean isUnknown = false;
            for (Fields fields : this.closure.getValueFields()) {
                isUnknown |= fields.isUnknown();
            }
            this.resultBuilder = isUnknown ? new TupleBuilder(){
                Tuple result = new Tuple();

                @Override
                public Tuple makeResult(Tuple[] tuples) {
                    this.result.clear();
                    for (Tuple lastValue : tuples) {
                        this.result.addAll(lastValue);
                    }
                    return this.result;
                }
            } : new TupleBuilder(){
                Tuple result;
                {
                    Object[] fields = closure.getValueFields();
                    if (closure.isSelfJoin()) {
                        fields = new Fields[closure.size()];
                        Arrays.fill(fields, closure.getValueFields()[0]);
                    }
                    this.result = TupleViews.createComposite((Fields[])fields);
                }

                @Override
                public Tuple makeResult(Tuple[] tuples) {
                    return TupleViews.reset(this.result, tuples);
                }
            };
        }

        protected Iterator getIterator(int i) {
            return this.closure.getIterator(i);
        }

        private Tuple[] initLastValues() {
            this.lastValues = new Tuple[this.iterators.length];
            for (int i = 0; i < this.iterators.length; ++i) {
                this.lastValues[i] = (Tuple)this.iterators[i].next();
            }
            return this.lastValues;
        }

        @Override
        public final boolean hasNext() {
            if (this.lastValues == null) {
                for (Iterator iterator : this.iterators) {
                    if (iterator.hasNext()) continue;
                    return false;
                }
                return true;
            }
            for (Iterator iterator : this.iterators) {
                if (!iterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Tuple next() {
            if (this.lastValues == null) {
                return this.makeResult(this.initLastValues());
            }
            for (int i = this.iterators.length - 1; i >= 0; --i) {
                if (this.iterators[i].hasNext()) {
                    this.lastValues[i] = (Tuple)this.iterators[i].next();
                    break;
                }
                this.iterators[i] = this.getIterator(i);
                this.lastValues[i] = (Tuple)this.iterators[i].next();
            }
            return this.makeResult(this.lastValues);
        }

        private Tuple makeResult(Tuple[] lastValues) {
            Tuples.asModifiable(this.result);
            this.result = this.resultBuilder.makeResult(lastValues);
            if (LOG.isTraceEnabled()) {
                LOG.trace("tuple: {}", (Object)this.result.print());
            }
            return this.result;
        }

        @Override
        public void remove() {
        }
    }
}

