/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.property.Props;
import cascading.util.cache.BaseCacheFactory;
import cascading.util.cache.LRUHashMapCacheFactory;
import java.util.Map;
import java.util.Properties;

public class UniqueProps
extends Props {
    public static String UNIQUE_CACHE_FACTORY = "cascading.unique.cachefactory.classname";
    public static final String UNIQUE_CACHE_CAPACITY = "cascading.aggregateby.cache.capacity";
    public static int UNIQUE_DEFAULT_CAPACITY = 10000;
    public static final Class<? extends BaseCacheFactory> DEFAULT_CACHE_FACTORY_CLASS = LRUHashMapCacheFactory.class;
    private Properties properties = new Properties();

    public static UniqueProps uniqueProps() {
        return new UniqueProps();
    }

    public UniqueProps setCacheFactoryClass(Class<? extends BaseCacheFactory> cacheFactory) {
        return this.setCacheFactoryClassName(cacheFactory.getName());
    }

    public UniqueProps setCacheFactoryClassName(String cacheFactoryClassName) {
        this.properties.setProperty(UNIQUE_CACHE_FACTORY, cacheFactoryClassName);
        return this;
    }

    public UniqueProps setCapacity(int capacity) {
        this.properties.setProperty(UNIQUE_CACHE_CAPACITY, String.valueOf(capacity));
        return this;
    }

    public int getCapacity() {
        String capacityValue = this.properties.getProperty(UNIQUE_CACHE_CAPACITY);
        if (capacityValue == null) {
            return 10000;
        }
        return Integer.valueOf(capacityValue);
    }

    public String getCacheFactoryClassName() {
        String className = this.properties.getProperty(UNIQUE_CACHE_FACTORY);
        if (className == null) {
            return DEFAULT_CACHE_FACTORY_CLASS.getName();
        }
        return className;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        properties.putAll((Map<?, ?>)this.properties);
    }
}

