/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.buffer.FirstNBuffer;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.assembly.UniqueProps;
import cascading.provider.FactoryLoader;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.util.TupleHasher;
import cascading.util.cache.BaseCacheFactory;
import cascading.util.cache.CacheEvictionCallback;
import cascading.util.cache.CascadingCache;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.Map;

public class Unique
extends SubAssembly {
    @ConstructorProperties(value={"pipe", "uniqueFields"})
    public Unique(Pipe pipe, Fields uniqueFields) {
        this(null, pipe, uniqueFields);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "include"})
    public Unique(Pipe pipe, Fields uniqueFields, Include include) {
        this(null, pipe, uniqueFields, include);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "capacity"})
    public Unique(Pipe pipe, Fields uniqueFields, int capacity) {
        this(null, pipe, uniqueFields, capacity);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "include", "capacity"})
    public Unique(Pipe pipe, Fields uniqueFields, Include include, int capacity) {
        this(null, pipe, uniqueFields, include, capacity);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields"})
    public Unique(String name, Pipe pipe, Fields uniqueFields) {
        this(name, pipe, uniqueFields, null);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "include"})
    public Unique(String name, Pipe pipe, Fields uniqueFields, Include include) {
        this(name, pipe, uniqueFields, include, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "capacity"})
    public Unique(String name, Pipe pipe, Fields uniqueFields, int capacity) {
        this(name, Pipe.pipes(pipe), uniqueFields, capacity);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "include", "capacity"})
    public Unique(String name, Pipe pipe, Fields uniqueFields, Include include, int capacity) {
        this(name, Pipe.pipes(pipe), uniqueFields, include, capacity);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields"})
    public Unique(Pipe[] pipes, Fields uniqueFields) {
        this(null, pipes, uniqueFields);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "include"})
    public Unique(Pipe[] pipes, Fields uniqueFields, Include include) {
        this(null, pipes, uniqueFields, include);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "capacity"})
    public Unique(Pipe[] pipes, Fields uniqueFields, int capacity) {
        this(null, pipes, uniqueFields, capacity);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "include", "capacity"})
    public Unique(Pipe[] pipes, Fields uniqueFields, Include include, int capacity) {
        this(null, pipes, uniqueFields, include, capacity);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields"})
    public Unique(String name, Pipe[] pipes, Fields uniqueFields) {
        this(name, pipes, uniqueFields, null);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "include"})
    public Unique(String name, Pipe[] pipes, Fields uniqueFields, Include include) {
        this(name, pipes, uniqueFields, include, 0);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "capacity"})
    public Unique(String name, Pipe[] pipes, Fields uniqueFields, int capacity) {
        this(name, pipes, uniqueFields, null, capacity);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "include", "capacity"})
    public Unique(String name, Pipe[] pipes, Fields uniqueFields, Include include, int capacity) {
        super(pipes);
        if (uniqueFields == null) {
            throw new IllegalArgumentException("uniqueFields may not be null");
        }
        Pipe[] filters = new Pipe[pipes.length];
        TupleHasher tupleHasher = null;
        Comparator[] comparators = uniqueFields.getComparators();
        if (!TupleHasher.isNull(comparators)) {
            tupleHasher = new TupleHasher(null, comparators);
        }
        FilterPartialDuplicates partialDuplicates = new FilterPartialDuplicates(include, capacity, tupleHasher);
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = new Each(pipes[i], uniqueFields, (Filter)partialDuplicates);
        }
        Pipe pipe = new GroupBy(name, filters, uniqueFields);
        pipe = new Every(pipe, Fields.ALL, new FirstNBuffer(), Fields.RESULTS);
        this.setTails(pipe);
    }

    public static class FilterPartialDuplicates
    extends BaseOperation<CascadingCache<Tuple, Object>>
    implements Filter<CascadingCache<Tuple, Object>> {
        private static final Object NULL_VALUE = new Object();
        private int capacity = 0;
        private Include include = Include.ALL;
        private TupleHasher tupleHasher;

        public FilterPartialDuplicates() {
        }

        @ConstructorProperties(value={"capacity"})
        public FilterPartialDuplicates(int capacity) {
            this.capacity = capacity;
        }

        @ConstructorProperties(value={"include", "capacity"})
        public FilterPartialDuplicates(Include include, int capacity) {
            this(include, capacity, null);
        }

        @ConstructorProperties(value={"include", "capacity", "tupleHasher"})
        public FilterPartialDuplicates(Include include, int capacity, TupleHasher tupleHasher) {
            this.capacity = capacity;
            this.include = include == null ? this.include : include;
            this.tupleHasher = tupleHasher;
        }

        @Override
        public void prepare(final FlowProcess flowProcess, OperationCall<CascadingCache<Tuple, Object>> operationCall) {
            CacheEvictionCallback callback = new CacheEvictionCallback(){

                public void evict(Map.Entry entry) {
                    flowProcess.increment(Cache.Num_Keys_Flushed, 1L);
                }
            };
            FactoryLoader loader = FactoryLoader.getInstance();
            BaseCacheFactory cacheFactory = loader.loadFactoryFrom(flowProcess, UniqueProps.UNIQUE_CACHE_FACTORY, UniqueProps.DEFAULT_CACHE_FACTORY_CLASS);
            if (cacheFactory == null) {
                throw new CascadingException("unable to load cache factory, please check your '" + UniqueProps.UNIQUE_CACHE_FACTORY + "' setting.");
            }
            Object cache = cacheFactory.create(flowProcess);
            cache.setCacheEvictionCallback(callback);
            Integer cacheCapacity = this.capacity;
            if (this.capacity == 0 && (cacheCapacity = flowProcess.getIntegerProperty("cascading.aggregateby.cache.capacity")) == null) {
                cacheCapacity = UniqueProps.UNIQUE_DEFAULT_CAPACITY;
            }
            cache.setCapacity(cacheCapacity);
            cache.initialize();
            operationCall.setContext((CascadingCache<Tuple, Object>)cache);
        }

        @Override
        public boolean isRemove(FlowProcess flowProcess, FilterCall<CascadingCache<Tuple, Object>> filterCall) {
            Tuple args = TupleHasher.wrapTuple(this.tupleHasher, filterCall.getArguments().getTuple());
            switch (this.include) {
                case ALL: {
                    break;
                }
                case NO_NULLS: {
                    if (Tuples.frequency(args, null) != args.size()) break;
                    return true;
                }
            }
            if (((CascadingCache)filterCall.getContext()).containsKey(args)) {
                flowProcess.increment(Cache.Num_Keys_Hit, 1L);
                return true;
            }
            ((CascadingCache)filterCall.getContext()).put(TupleHasher.wrapTuple(this.tupleHasher, filterCall.getArguments().getTupleCopy()), NULL_VALUE);
            flowProcess.increment(Cache.Num_Keys_Missed, 1L);
            return false;
        }

        @Override
        public void cleanup(FlowProcess flowProcess, OperationCall<CascadingCache<Tuple, Object>> operationCall) {
            operationCall.setContext(null);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FilterPartialDuplicates)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            FilterPartialDuplicates that = (FilterPartialDuplicates)object;
            return this.capacity == that.capacity;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.capacity;
            return result;
        }
    }

    public static enum Cache {
        Num_Keys_Flushed,
        Num_Keys_Hit,
        Num_Keys_Missed;

    }

    public static enum Include {
        ALL,
        NO_NULLS;

    }
}

