/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.pipe.Pipe;
import cascading.pipe.assembly.AggregateByLocally;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import java.beans.ConstructorProperties;

public class CountByLocally
extends AggregateByLocally {
    @ConstructorProperties(value={"countField"})
    public CountByLocally(Fields countField) {
        super(Fields.ALL, new CountPartials(countField.applyTypes(Long.TYPE)));
    }

    @ConstructorProperties(value={"countField", "include"})
    public CountByLocally(Fields countField, Include include) {
        super(Fields.ALL, new CountPartials(countField, include));
    }

    @ConstructorProperties(value={"valueFields", "countField"})
    public CountByLocally(Fields valueFields, Fields countField) {
        super(valueFields, new CountPartials(countField));
    }

    @ConstructorProperties(value={"valueFields", "countField", "include"})
    public CountByLocally(Fields valueFields, Fields countField, Include include) {
        super(valueFields, new CountPartials(countField, include));
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "countField"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields countField) {
        this(null, pipe, groupingFields, countField);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "countField", "threshold"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields countField, int threshold) {
        this(null, pipe, groupingFields, countField, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "countField"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields countField) {
        this(name, pipe, groupingFields, countField, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "countField", "threshold"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields countField, int threshold) {
        super(name, pipe, groupingFields, groupingFields, new CountPartials(countField), threshold);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "countField", "include"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields countField, Include include) {
        this(null, pipe, groupingFields, countField, include);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "countField", "include", "threshold"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields countField, Include include, int threshold) {
        this(null, pipe, groupingFields, countField, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "countField", "include"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields countField, Include include) {
        this(name, pipe, groupingFields, countField, include, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "countField", "include", "threshold"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields countField, Include include, int threshold) {
        super(name, pipe, groupingFields, groupingFields, new CountPartials(countField, include), threshold);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueFields", "countField"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField) {
        this(null, pipe, groupingFields, valueFields, countField, Include.ALL);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueFields", "countField", "threshold"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, int threshold) {
        this(null, pipe, groupingFields, valueFields, countField, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueFields", "countField"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField) {
        this(name, pipe, groupingFields, valueFields, countField, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueFields", "countField", "threshold"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, int threshold) {
        super(name, pipe, groupingFields, valueFields, new CountPartials(countField), threshold);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueFields", "countField", "include"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, Include include) {
        this(null, pipe, groupingFields, valueFields, countField, include);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueFields", "countField", "include", "threshold"})
    public CountByLocally(Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, Include include, int threshold) {
        this(null, pipe, groupingFields, valueFields, countField, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueFields", "countField", "include"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, Include include) {
        this(name, pipe, groupingFields, valueFields, countField, include, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueFields", "countField", "include", "threshold"})
    public CountByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueFields, Fields countField, Include include, int threshold) {
        super(name, pipe, groupingFields, valueFields, new CountPartials(countField, include), threshold);
    }

    public static class CountPartials
    implements AggregateByLocally.Functor {
        private final Fields declaredFields;
        private final Include include;
        private final CoercibleType canonical;

        public CountPartials(Fields declaredFields) {
            this(declaredFields, Include.ALL);
        }

        public CountPartials(Fields declaredFields, Include include) {
            if (!declaredFields.isDeclarator() || declaredFields.size() != 1) {
                throw new IllegalArgumentException("declaredFields should declare only one field name");
            }
            if (declaredFields.getType(0) == null) {
                declaredFields = declaredFields.applyTypes(Long.TYPE);
            }
            this.declaredFields = declaredFields;
            if (include == null) {
                include = Include.ALL;
            }
            this.include = include;
            this.canonical = Coercions.coercibleTypeFor(this.declaredFields.getType(0));
        }

        @Override
        public Fields getDeclaredFields() {
            return this.declaredFields;
        }

        @Override
        public Tuple aggregate(FlowProcess flowProcess, TupleEntry args, Tuple context) {
            if (context == null) {
                context = new Tuple(0L);
            }
            switch (this.include) {
                case ALL: {
                    break;
                }
                case NO_NULLS: {
                    if (Tuples.frequency(args, null) != args.size()) break;
                    return context;
                }
                case ONLY_NULLS: {
                    if (Tuples.frequency(args, null) == args.size()) break;
                    return context;
                }
            }
            context.set(0, context.getLong(0) + 1L);
            return context;
        }

        @Override
        public Tuple complete(FlowProcess flowProcess, Tuple context) {
            context.set(0, this.canonical.canonical(context.getObject(0)));
            return context;
        }
    }

    public static enum Include {
        ALL,
        NO_NULLS,
        ONLY_NULLS;

    }
}

