/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.pipe.Pipe;
import cascading.pipe.assembly.AggregateByLocally;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;

public class AverageByLocally
extends AggregateByLocally {
    @ConstructorProperties(value={"valueField", "averageField"})
    public AverageByLocally(Fields valueField, Fields averageField) {
        super(valueField, new AveragePartials(averageField));
    }

    @ConstructorProperties(value={"valueField", "averageField", "include"})
    public AverageByLocally(Fields valueField, Fields averageField, Include include) {
        super(valueField, new AveragePartials(averageField, include));
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField"})
    public AverageByLocally(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField) {
        this(null, pipe, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageByLocally(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        this(null, pipe, groupingFields, valueField, averageField, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField"})
    public AverageByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField) {
        this(name, pipe, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        super(name, pipe, groupingFields, valueField, new AveragePartials(averageField), threshold);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "include"})
    public AverageByLocally(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(null, pipe, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageByLocally(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        this(null, pipe, groupingFields, valueField, averageField, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "include"})
    public AverageByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(name, pipe, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageByLocally(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        super(name, pipe, groupingFields, valueField, new AveragePartials(averageField, include), threshold);
    }

    public static class AveragePartials
    implements AggregateByLocally.Functor {
        private final Fields declaredFields;
        private final Include include;
        private final Type type;
        private final CoercibleType canonical;

        public AveragePartials(Fields declaredFields) {
            this(declaredFields, Include.ALL);
        }

        public AveragePartials(Fields declaredFields, Include include) {
            this.declaredFields = AveragePartials.makeFieldDeclaration(declaredFields);
            this.include = include;
            this.type = this.declaredFields.hasTypes() ? this.declaredFields.getType(0) : Double.class;
            this.canonical = Coercions.coercibleTypeFor(this.type);
        }

        private static Fields makeFieldDeclaration(Fields fieldDeclaration) {
            if (fieldDeclaration.hasTypes()) {
                return fieldDeclaration;
            }
            return fieldDeclaration.applyTypes(new Type[]{Double.class});
        }

        @Override
        public Fields getDeclaredFields() {
            return this.declaredFields;
        }

        @Override
        public Tuple aggregate(FlowProcess flowProcess, TupleEntry args, Tuple context) {
            if (context == null) {
                context = Tuple.size(2);
            }
            if (this.include == Include.NO_NULLS && args.getObject(0) == null) {
                return context;
            }
            context.set(0, context.getDouble(0) + args.getDouble(Integer.valueOf(0)));
            context.set(1, context.getLong(1) + 1L);
            return context;
        }

        @Override
        public Tuple complete(FlowProcess flowProcess, Tuple context) {
            long count = context.getLong(1);
            if (count == 0L) {
                return new Tuple(this.canonical.canonical(null));
            }
            double sum = context.getDouble(0);
            return new Tuple(this.canonical.canonical(sum / (double)count));
        }
    }

    public static enum Include {
        ALL,
        NO_NULLS;

    }
}

