/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.pipe.Pipe;
import cascading.pipe.assembly.AggregateBy;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;

public class AverageBy
extends AggregateBy {
    @ConstructorProperties(value={"valueField", "averageField"})
    public AverageBy(Fields valueField, Fields averageField) {
        super(valueField, new AveragePartials(averageField), new AverageFinal(averageField));
    }

    @ConstructorProperties(value={"valueField", "averageField", "include"})
    public AverageBy(Fields valueField, Fields averageField, Include include) {
        super(valueField, new AveragePartials(averageField, include), new AverageFinal(averageField));
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField"})
    public AverageBy(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField) {
        this(null, pipe, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageBy(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        this(null, pipe, groupingFields, valueField, averageField, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField"})
    public AverageBy(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField) {
        this(name, pipe, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageBy(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        this(name, Pipe.pipes(pipe), groupingFields, valueField, averageField, threshold);
    }

    @ConstructorProperties(value={"pipes", "groupingFields", "valueField", "averageField"})
    public AverageBy(Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField) {
        this(null, pipes, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"pipes", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageBy(Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        this(null, pipes, groupingFields, valueField, averageField, threshold);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "valueField", "averageField"})
    public AverageBy(String name, Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField) {
        this(name, pipes, groupingFields, valueField, averageField, 0);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "valueField", "averageField", "threshold"})
    public AverageBy(String name, Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, int threshold) {
        super(name, pipes, groupingFields, valueField, new AveragePartials(averageField), new AverageFinal(averageField), threshold);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "include"})
    public AverageBy(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(null, pipe, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageBy(Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        this(null, pipe, groupingFields, valueField, averageField, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "include"})
    public AverageBy(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(name, pipe, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageBy(String name, Pipe pipe, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        this(name, Pipe.pipes(pipe), groupingFields, valueField, averageField, include, threshold);
    }

    @ConstructorProperties(value={"pipes", "groupingFields", "valueField", "averageField", "include"})
    public AverageBy(Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(null, pipes, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"pipes", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageBy(Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        this(null, pipes, groupingFields, valueField, averageField, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "valueField", "averageField", "include"})
    public AverageBy(String name, Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, Include include) {
        this(name, pipes, groupingFields, valueField, averageField, include, 0);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "valueField", "averageField", "include", "threshold"})
    public AverageBy(String name, Pipe[] pipes, Fields groupingFields, Fields valueField, Fields averageField, Include include, int threshold) {
        super(name, pipes, groupingFields, valueField, new AveragePartials(averageField, include), new AverageFinal(averageField), threshold);
    }

    public static class AverageFinal
    extends BaseOperation<Context>
    implements Aggregator<Context> {
        public AverageFinal(Fields fieldDeclaration) {
            super(2, AverageFinal.makeFieldDeclaration(fieldDeclaration));
            if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
                throw new IllegalArgumentException("fieldDeclaration may only declare 1 field, got: " + fieldDeclaration.size());
            }
        }

        private static Fields makeFieldDeclaration(Fields fieldDeclaration) {
            if (fieldDeclaration.hasTypes()) {
                return fieldDeclaration;
            }
            return fieldDeclaration.applyTypes(new Type[]{Double.class});
        }

        @Override
        public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
            operationCall.setContext(new Context(this.getFieldDeclaration()));
        }

        @Override
        public void start(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
            ((Context)aggregatorCall.getContext()).reset();
        }

        @Override
        public void aggregate(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
            Context context = (Context)aggregatorCall.getContext();
            TupleEntry arguments = aggregatorCall.getArguments();
            if (arguments.getObject(0) == null) {
                ++context.nulls;
                return;
            }
            context.sum += arguments.getDouble(Integer.valueOf(0));
            context.count += arguments.getLong(Integer.valueOf(1));
        }

        @Override
        public void complete(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
            aggregatorCall.getOutputCollector().add(((Context)aggregatorCall.getContext()).result());
        }

        protected static class Context {
            long nulls = 0L;
            double sum = 0.0;
            long count = 0L;
            Type type = Double.class;
            CoercibleType canonical;
            Tuple tuple = Tuple.size(1);

            public Context(Fields fieldDeclaration) {
                if (fieldDeclaration.hasTypes()) {
                    this.type = fieldDeclaration.getType(0);
                }
                this.canonical = Coercions.coercibleTypeFor(this.type);
            }

            public Context reset() {
                this.nulls = 0L;
                this.sum = 0.0;
                this.count = 0L;
                this.tuple.set(0, null);
                return this;
            }

            public Tuple result() {
                if (this.count == 0L && this.nulls != 0L) {
                    return this.tuple;
                }
                this.tuple.set(0, this.canonical.canonical(this.sum / (double)this.count));
                return this.tuple;
            }
        }
    }

    public static class AveragePartials
    implements AggregateBy.Functor {
        private final Fields declaredFields;
        private final Include include;

        public AveragePartials(Fields declaredFields) {
            this.declaredFields = declaredFields;
            this.include = Include.ALL;
        }

        public AveragePartials(Fields declaredFields, Include include) {
            this.declaredFields = declaredFields;
            if (include == null) {
                include = Include.ALL;
            }
            this.include = include;
        }

        @Override
        public Fields getDeclaredFields() {
            Fields sumName = new Fields((Comparable)((Object)(AverageBy.class.getPackage().getName() + "." + this.declaredFields.get(0) + ".sum")), (Type)((Object)Double.class));
            Fields countName = new Fields((Comparable)((Object)(AverageBy.class.getPackage().getName() + "." + this.declaredFields.get(0) + ".count")), (Type)((Object)Long.class));
            return sumName.append(countName);
        }

        @Override
        public Tuple aggregate(FlowProcess flowProcess, TupleEntry args, Tuple context) {
            if (context == null) {
                context = Tuple.size(2);
            }
            if (this.include == Include.NO_NULLS && args.getObject(0) == null) {
                return context;
            }
            context.set(0, context.getDouble(0) + args.getDouble(Integer.valueOf(0)));
            context.set(1, context.getLong(1) + 1L);
            return context;
        }

        @Override
        public Tuple complete(FlowProcess flowProcess, Tuple context) {
            return context;
        }
    }

    public static enum Include {
        ALL,
        NO_NULLS;

    }
}

