/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.property.Props;
import cascading.util.cache.BaseCacheFactory;
import cascading.util.cache.LRUHashMapCacheFactory;
import java.util.Map;
import java.util.Properties;

public class AggregateByLocallyProps
extends Props {
    public static String AGGREGATE_LOCALLY_BY_CACHE_FACTORY = "cascading.aggregateby.locally.cachefactory.classname";
    public static final String AGGREGATE_LOCALLY_BY_CAPACITY = "cascading.aggregateby.locally.cache.capacity";
    public static int AGGREGATE_LOCALLY_BY_DEFAULT_CAPACITY = 10000;
    public static final Class<? extends BaseCacheFactory> DEFAULT_CACHE_FACTORY_CLASS = LRUHashMapCacheFactory.class;
    private Properties properties = new Properties();

    public static AggregateByLocallyProps aggregateByLocallyProps() {
        return new AggregateByLocallyProps();
    }

    public AggregateByLocallyProps setCacheFactoryClass(Class<? extends BaseCacheFactory> cacheFactory) {
        return this.setCacheFactoryClassName(cacheFactory.getName());
    }

    public AggregateByLocallyProps setCacheFactoryClassName(String cacheFactoryClassName) {
        this.properties.setProperty(AGGREGATE_LOCALLY_BY_CACHE_FACTORY, cacheFactoryClassName);
        return this;
    }

    public AggregateByLocallyProps setCapacity(int capacity) {
        this.properties.setProperty(AGGREGATE_LOCALLY_BY_CAPACITY, String.valueOf(capacity));
        return this;
    }

    public int getCapacity() {
        String capacityValue = this.properties.getProperty(AGGREGATE_LOCALLY_BY_CAPACITY);
        if (capacityValue == null) {
            return 10000;
        }
        return Integer.valueOf(capacityValue);
    }

    public String getCacheFactoryClassName() {
        String className = this.properties.getProperty(AGGREGATE_LOCALLY_BY_CACHE_FACTORY);
        if (className == null) {
            return DEFAULT_CACHE_FACTORY_CLASS.getName();
        }
        return className;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        properties.putAll((Map<?, ?>)this.properties);
    }
}

