/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyConfigured;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.CompositeFunction;
import cascading.operation.Function;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.assembly.AggregateByLocallyProps;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.cache.BaseCacheFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;

public class AggregateByLocally
extends SubAssembly {
    public static final int USE_DEFAULT_THRESHOLD = 0;
    private String name;
    private int capacity;
    private Fields groupingFields;
    private Fields[] argumentFields;
    private Functor[] functors;

    protected AggregateByLocally(String name, int capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    protected AggregateByLocally(Fields argumentFields, Functor functor) {
        this.argumentFields = Fields.fields(argumentFields);
        this.functors = new Functor[]{functor};
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "assemblies"})
    public AggregateByLocally(Pipe pipe, Fields groupingFields, AggregateByLocally ... assemblies) {
        this(null, pipe, groupingFields, 0, assemblies);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "capacity", "assemblies"})
    public AggregateByLocally(Pipe pipe, Fields groupingFields, int capacity, AggregateByLocally ... assemblies) {
        this(null, pipe, groupingFields, capacity, assemblies);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "capacity", "assemblies"})
    public AggregateByLocally(String name, Pipe pipe, Fields groupingFields, int capacity, AggregateByLocally ... assemblies) {
        this(name, capacity);
        ArrayList arguments = new ArrayList();
        ArrayList functors = new ArrayList();
        for (int i = 0; i < assemblies.length; ++i) {
            AggregateByLocally assembly = assemblies[i];
            Collections.addAll(arguments, assembly.getArgumentFields());
            Collections.addAll(functors, assembly.getFunctors());
        }
        this.initialize(groupingFields, pipe, arguments.toArray(new Fields[arguments.size()]), functors.toArray(new Functor[functors.size()]));
    }

    protected AggregateByLocally(String name, Pipe pipe, Fields groupingFields, Fields argumentFields, Functor functor, int capacity) {
        this(name, capacity);
        this.initialize(groupingFields, pipe, argumentFields, functor);
    }

    protected void initialize(Fields groupingFields, Pipe pipe, Fields argumentFields, Functor functor) {
        this.initialize(groupingFields, pipe, Fields.fields(argumentFields), new Functor[]{functor});
    }

    protected void initialize(Fields groupingFields, Pipe pipe, Fields[] argumentFields, Functor[] functors) {
        this.setPrevious(pipe);
        this.groupingFields = groupingFields;
        this.argumentFields = argumentFields;
        this.functors = functors;
        this.verify();
        Fields sortFields = Fields.copyComparators(Fields.merge(this.argumentFields), this.argumentFields);
        Fields argumentSelector = Fields.merge(this.groupingFields, sortFields);
        if (argumentSelector.equals(Fields.NONE)) {
            argumentSelector = Fields.ALL;
        }
        CompositeFunction function = new CompositeFunction(this.groupingFields, this.argumentFields, this.functors, this.capacity);
        if (this.name != null) {
            pipe = new Pipe(this.name);
        }
        pipe = new Each(pipe, argumentSelector, (Function)function, Fields.RESULTS);
        this.setTails(pipe);
    }

    protected void verify() {
    }

    public Fields getGroupingFields() {
        return this.groupingFields;
    }

    public Fields[] getFieldDeclarations() {
        Fields[] fields = new Fields[this.functors.length];
        for (int i = 0; i < this.functors.length; ++i) {
            fields[i] = this.functors[i].getDeclaredFields();
        }
        return fields;
    }

    protected Fields[] getArgumentFields() {
        return this.argumentFields;
    }

    protected Functor[] getFunctors() {
        return this.functors;
    }

    @Property(name="capacity", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="Capacity of the aggregation cache.")
    @PropertyConfigured(value="cascading.aggregateby.locally.cache.capacity", defaultValue="10000")
    public int getCapacity() {
        return this.capacity;
    }

    public static class CompositeFunction
    extends cascading.operation.CompositeFunction {
        public CompositeFunction(Fields groupingFields, Fields argumentFields, CompositeFunction.CoFunction coFunction, int capacity) {
            super(groupingFields, argumentFields, coFunction, capacity);
        }

        public CompositeFunction(Fields groupingFields, Fields[] argumentFields, CompositeFunction.CoFunction[] coFunctions, int capacity) {
            super(groupingFields, argumentFields, coFunctions, capacity);
        }

        @Override
        protected void incrementNumKeysFlushed(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Flushed, 1L);
        }

        @Override
        protected void incrementNumKeysHit(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Hit, 1L);
        }

        @Override
        protected void incrementNumKeysMissed(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Missed, 1L);
        }

        @Override
        protected Integer getCacheCapacity(FlowProcess flowProcess) {
            return this.getCacheCapacity(flowProcess, "cascading.aggregateby.locally.cache.capacity", AggregateByLocallyProps.AGGREGATE_LOCALLY_BY_DEFAULT_CAPACITY);
        }

        @Override
        protected BaseCacheFactory<Tuple, Tuple[], ?> loadCacheFactory(FlowProcess flowProcess) {
            return this.loadCacheFactory(flowProcess, AggregateByLocallyProps.AGGREGATE_LOCALLY_BY_CACHE_FACTORY, AggregateByLocallyProps.DEFAULT_CACHE_FACTORY_CLASS);
        }
    }

    public static interface Functor
    extends CompositeFunction.CoFunction {
    }

    public static enum Cache {
        Num_Keys_Flushed,
        Num_Keys_Hit,
        Num_Keys_Missed;

    }
}

