/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyConfigured;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.Aggregator;
import cascading.operation.CompositeFunction;
import cascading.operation.Function;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.assembly.AggregateByProps;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.cache.BaseCacheFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;

public class AggregateBy
extends SubAssembly {
    public static final int USE_DEFAULT_THRESHOLD = 0;
    private String name;
    private int capacity;
    private Fields groupingFields;
    private Fields[] argumentFields;
    private Functor[] functors;
    private Aggregator[] aggregators;
    private transient GroupBy groupBy;

    protected AggregateBy(String name, int capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    protected AggregateBy(Fields argumentFields, Functor functor, Aggregator aggregator) {
        this.argumentFields = Fields.fields(argumentFields);
        this.functors = new Functor[]{functor};
        this.aggregators = new Aggregator[]{aggregator};
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "assemblies"})
    public AggregateBy(Pipe pipe, Fields groupingFields, AggregateBy ... assemblies) {
        this(null, Pipe.pipes(pipe), groupingFields, 0, assemblies);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "capacity", "assemblies"})
    public AggregateBy(Pipe pipe, Fields groupingFields, int capacity, AggregateBy ... assemblies) {
        this(null, Pipe.pipes(pipe), groupingFields, capacity, assemblies);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "capacity", "assemblies"})
    public AggregateBy(String name, Pipe pipe, Fields groupingFields, int capacity, AggregateBy ... assemblies) {
        this(name, Pipe.pipes(pipe), groupingFields, capacity, assemblies);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "assemblies"})
    public AggregateBy(String name, Pipe[] pipes, Fields groupingFields, AggregateBy ... assemblies) {
        this(name, pipes, groupingFields, 0, assemblies);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "capacity", "assemblies"})
    public AggregateBy(String name, Pipe[] pipes, Fields groupingFields, int capacity, AggregateBy ... assemblies) {
        this(name, capacity);
        ArrayList arguments = new ArrayList();
        ArrayList functors = new ArrayList();
        ArrayList aggregators = new ArrayList();
        for (int i = 0; i < assemblies.length; ++i) {
            AggregateBy assembly = assemblies[i];
            Collections.addAll(arguments, assembly.getArgumentFields());
            Collections.addAll(functors, assembly.getFunctors());
            Collections.addAll(aggregators, assembly.getAggregators());
        }
        this.initialize(groupingFields, pipes, arguments.toArray(new Fields[arguments.size()]), functors.toArray(new Functor[functors.size()]), aggregators.toArray(new Aggregator[aggregators.size()]));
    }

    protected AggregateBy(String name, Pipe[] pipes, Fields groupingFields, Fields argumentFields, Functor functor, Aggregator aggregator, int capacity) {
        this(name, capacity);
        this.initialize(groupingFields, pipes, argumentFields, functor, aggregator);
    }

    protected void initialize(Fields groupingFields, Pipe[] pipes, Fields argumentFields, Functor functor, Aggregator aggregator) {
        this.initialize(groupingFields, pipes, Fields.fields(argumentFields), new Functor[]{functor}, new Aggregator[]{aggregator});
    }

    protected void initialize(Fields groupingFields, Pipe[] pipes, Fields[] argumentFields, Functor[] functors, Aggregator[] aggregators) {
        this.setPrevious(pipes);
        this.groupingFields = groupingFields;
        this.argumentFields = argumentFields;
        this.functors = functors;
        this.aggregators = aggregators;
        this.verify();
        Fields sortFields = Fields.copyComparators(Fields.merge(this.argumentFields), this.argumentFields);
        Fields argumentSelector = Fields.merge(this.groupingFields, sortFields);
        if (argumentSelector.equals(Fields.NONE)) {
            argumentSelector = Fields.ALL;
        }
        Pipe[] functions = new Pipe[pipes.length];
        CompositeFunction function = new CompositeFunction(this.groupingFields, this.argumentFields, this.functors, this.capacity);
        for (int i = 0; i < functions.length; ++i) {
            functions[i] = new Each(pipes[i], argumentSelector, (Function)function, Fields.RESULTS);
        }
        Pipe pipe = this.groupBy = new GroupBy(this.name, functions, this.groupingFields, sortFields.hasComparators() ? sortFields : null);
        for (int i = 0; i < aggregators.length; ++i) {
            pipe = new Every(pipe, this.functors[i].getDeclaredFields(), this.aggregators[i], Fields.ALL);
        }
        this.setTails(pipe);
    }

    protected void verify() {
    }

    public Fields getGroupingFields() {
        return this.groupingFields;
    }

    public Fields[] getFieldDeclarations() {
        Fields[] fields = new Fields[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            fields[i] = this.aggregators[i].getFieldDeclaration();
        }
        return fields;
    }

    protected Fields[] getArgumentFields() {
        return this.argumentFields;
    }

    protected Functor[] getFunctors() {
        return this.functors;
    }

    protected Aggregator[] getAggregators() {
        return this.aggregators;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Property(name="capacity", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="Capacity of the aggregation cache.")
    @PropertyConfigured(value="cascading.aggregateby.cache.capacity", defaultValue="10000")
    public int getCapacity() {
        return this.capacity;
    }

    public static class CompositeFunction
    extends cascading.operation.CompositeFunction {
        public CompositeFunction(Fields groupingFields, Fields argumentFields, CompositeFunction.CoFunction coFunction, int capacity) {
            super(groupingFields, argumentFields, coFunction, capacity);
        }

        public CompositeFunction(Fields groupingFields, Fields[] argumentFields, CompositeFunction.CoFunction[] coFunctions, int capacity) {
            super(groupingFields, argumentFields, coFunctions, capacity);
        }

        @Override
        protected void incrementNumKeysFlushed(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Flushed, 1L);
        }

        @Override
        protected void incrementNumKeysHit(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Hit, 1L);
        }

        @Override
        protected void incrementNumKeysMissed(FlowProcess flowProcess) {
            flowProcess.increment(Cache.Num_Keys_Missed, 1L);
        }

        @Override
        protected Integer getCacheCapacity(FlowProcess flowProcess) {
            return this.getCacheCapacity(flowProcess, "cascading.aggregateby.cache.capacity", AggregateByProps.AGGREGATE_BY_DEFAULT_CAPACITY);
        }

        @Override
        protected BaseCacheFactory<Tuple, Tuple[], ?> loadCacheFactory(FlowProcess flowProcess) {
            return this.loadCacheFactory(flowProcess, AggregateByProps.AGGREGATE_BY_CACHE_FACTORY, AggregateByProps.DEFAULT_CACHE_FACTORY_CLASS);
        }
    }

    public static interface Functor
    extends CompositeFunction.CoFunction {
    }

    public static enum Cache {
        Num_Keys_Flushed,
        Num_Keys_Hit,
        Num_Keys_Missed;

    }
}

