/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.ScopedElement;
import cascading.pipe.Operator;
import cascading.pipe.Splice;
import cascading.pipe.SubAssembly;
import cascading.property.ConfigDef;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Pipe
implements ScopedElement,
FlowElement,
Serializable,
Traceable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Pipe previous;
    protected Pipe parent;
    protected ConfigDef configDef;
    protected ConfigDef stepConfigDef;
    protected ConfigDef nodeConfigDef;
    private final String id = Util.createUniqueID();
    private String trace = TraceUtil.captureDebugTrace(this);

    public static synchronized String id(Pipe pipe) {
        return pipe.id;
    }

    public static Pipe[] pipes(Pipe ... pipes) {
        return pipes;
    }

    public static String[] names(Pipe ... tails) {
        HashSet<String> names = new HashSet<String>();
        Pipe.collectNames(tails, names);
        return names.toArray(new String[names.size()]);
    }

    private static void collectNames(Pipe[] pipes, Set<String> names) {
        for (Pipe pipe : pipes) {
            if (pipe instanceof SubAssembly) {
                names.addAll(Arrays.asList(((SubAssembly)pipe).getTailNames()));
            } else {
                names.add(pipe.getName());
            }
            Pipe.collectNames(SubAssembly.unwind(pipe.getPrevious()), names);
        }
    }

    public static Pipe[] named(String name, Pipe ... tails) {
        HashSet<Pipe> pipes = new HashSet<Pipe>();
        Pipe.collectPipes(name, tails, pipes);
        return pipes.toArray(new Pipe[pipes.size()]);
    }

    private static void collectPipes(String name, Pipe[] tails, Set<Pipe> pipes) {
        for (Pipe tail : tails) {
            if (!(tail instanceof SubAssembly) && tail.getName().equals(name)) {
                pipes.add(tail);
            }
            Pipe.collectPipes(name, SubAssembly.unwind(tail.getPrevious()), pipes);
        }
    }

    static Pipe[] resolvePreviousAll(Pipe ... pipes) {
        Pipe[] resolved = new Pipe[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            resolved[i] = Pipe.resolvePrevious(pipes[i]);
        }
        return resolved;
    }

    static Pipe resolvePrevious(Pipe pipe) {
        if (pipe instanceof Splice || pipe instanceof Operator) {
            return pipe;
        }
        Pipe[] pipes = pipe.getPrevious();
        if (pipes.length > 1) {
            throw new IllegalStateException("cannot resolve SubAssemblies with multiple tails at this time");
        }
        int n = 0;
        Pipe[] pipeArray = pipes;
        int n2 = pipeArray.length;
        if (n < n2) {
            Pipe previous = pipeArray[n];
            if (previous instanceof Splice || previous instanceof Operator) {
                return previous;
            }
            return Pipe.resolvePrevious(previous);
        }
        return pipe;
    }

    protected Pipe() {
    }

    @ConstructorProperties(value={"previous"})
    protected Pipe(Pipe previous) {
        this.previous = previous;
        this.verifyPipe();
    }

    @ConstructorProperties(value={"name"})
    public Pipe(String name) {
        this.name = name;
    }

    @ConstructorProperties(value={"name", "previous"})
    public Pipe(String name, Pipe previous) {
        this.name = name;
        this.previous = previous;
        this.verifyPipe();
    }

    private void verifyPipe() {
        if (!(this.previous instanceof SubAssembly)) {
            return;
        }
        Object[] strings = ((SubAssembly)this.previous).getTailNames();
        if (strings.length != 1) {
            throw new IllegalArgumentException("pipe assembly must not return more than one tail pipe instance, found " + Util.join(strings, ", "));
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.previous != null) {
            this.name = this.previous.getName();
            return this.name;
        }
        return "ANONYMOUS";
    }

    public Pipe[] getPrevious() {
        if (this.previous == null) {
            return new Pipe[0];
        }
        return new Pipe[]{this.previous};
    }

    protected void setParent(Pipe parent) {
        this.parent = parent;
    }

    public Pipe getParent() {
        return this.parent;
    }

    @Override
    public ConfigDef getConfigDef() {
        if (this.configDef == null) {
            this.configDef = new ConfigDef();
        }
        return this.configDef;
    }

    @Override
    public boolean hasConfigDef() {
        return this.configDef != null && !this.configDef.isEmpty();
    }

    @Override
    public ConfigDef getNodeConfigDef() {
        if (this.nodeConfigDef == null) {
            this.nodeConfigDef = new ConfigDef();
        }
        return this.nodeConfigDef;
    }

    @Override
    public boolean hasNodeConfigDef() {
        return this.nodeConfigDef != null && !this.nodeConfigDef.isEmpty();
    }

    @Override
    public ConfigDef getStepConfigDef() {
        if (this.stepConfigDef == null) {
            this.stepConfigDef = new ConfigDef();
        }
        return this.stepConfigDef;
    }

    @Override
    public boolean hasStepConfigDef() {
        return this.stepConfigDef != null && !this.stepConfigDef.isEmpty();
    }

    public Pipe[] getHeads() {
        Pipe[] pipes = this.getPrevious();
        if (pipes.length == 0) {
            return new Pipe[]{this};
        }
        if (pipes.length == 1) {
            return pipes[0].getHeads();
        }
        HashSet heads = new HashSet();
        for (Pipe pipe : pipes) {
            Collections.addAll(heads, pipe.getHeads());
        }
        return heads.toArray(new Pipe[heads.size()]);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        return incomingScopes.iterator().next();
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        throw new IllegalStateException("resolveIncomingOperationFields should never be called");
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        throw new IllegalStateException("resolveIncomingOperationPassThroughFields should never be called");
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    Scope getFirst(Set<Scope> incomingScopes) {
        return incomingScopes.iterator().next();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.getClass().hashCode();
    }

    public String print(Scope scope) {
        StringBuffer buffer = new StringBuffer();
        this.printInternal(buffer, scope);
        return buffer.toString();
    }

    protected void printInternal(StringBuffer buffer, Scope scope) {
        buffer.append(this.getClass().getSimpleName()).append("('").append(this.getName()).append("')");
    }
}

