/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.CascadingException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;

public class OperatorException
extends CascadingException {
    private Fields incomingFields;
    private Fields argumentSelector;
    private Fields groupingSelector;
    private Fields sortingSelector;
    private Fields declaredFields;
    private Fields outputSelector;

    public OperatorException() {
    }

    public OperatorException(Pipe pipe, String string) {
        super(TraceUtil.formatTrace(pipe, string));
    }

    public OperatorException(Pipe pipe, String string, Throwable throwable) {
        super(TraceUtil.formatTrace(pipe, string), throwable);
    }

    protected OperatorException(String string) {
        super(string);
    }

    protected OperatorException(String string, Throwable throwable) {
        super(string, throwable);
    }

    protected OperatorException(Throwable throwable) {
        super(throwable);
    }

    public OperatorException(Pipe pipe, Fields incomingFields, Fields declaredFields, Fields outputSelector, Throwable throwable) {
        super(OperatorException.createMessage(pipe, incomingFields, declaredFields, outputSelector), throwable);
        this.incomingFields = incomingFields;
        this.declaredFields = declaredFields;
        this.outputSelector = outputSelector;
    }

    public OperatorException(Pipe pipe, Kind kind, Fields incomingFields, Fields selectorFields, Throwable throwable) {
        super(OperatorException.createMessage(pipe, kind, incomingFields, selectorFields), throwable);
        this.incomingFields = incomingFields;
        if (kind == Kind.argument) {
            this.argumentSelector = selectorFields;
        } else if (kind == Kind.grouping) {
            this.groupingSelector = selectorFields;
        } else {
            this.sortingSelector = selectorFields;
        }
    }

    public Fields getIncomingFields() {
        return this.incomingFields;
    }

    public Fields getArgumentSelector() {
        return this.argumentSelector;
    }

    public Fields getGroupingSelector() {
        return this.groupingSelector;
    }

    public Fields getSortingSelector() {
        return this.sortingSelector;
    }

    public Fields getDeclaredFields() {
        return this.declaredFields;
    }

    public Fields getOutputSelector() {
        return this.outputSelector;
    }

    private static String createMessage(Pipe pipe, Fields incomingFields, Fields declaredFields, Fields outputSelector) {
        String message = "unable to resolve output selector: " + outputSelector.printVerbose() + ", with incoming: " + incomingFields.printVerbose() + " and declared: " + declaredFields.printVerbose();
        return TraceUtil.formatTrace(pipe, message);
    }

    private static String createMessage(Pipe pipe, Kind kind, Fields incomingFields, Fields argumentSelector) {
        String message = "unable to resolve " + (Object)((Object)kind) + " selector: " + argumentSelector.printVerbose() + ", with incoming: " + incomingFields.printVerbose();
        return TraceUtil.formatTrace(pipe, message);
    }

    static enum Kind {
        argument,
        grouping,
        sorting,
        joining;

    }
}

