/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.planner.Scope;
import cascading.operation.Aggregator;
import cascading.operation.AssertionLevel;
import cascading.operation.Buffer;
import cascading.operation.GroupAssertion;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.Operator;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.util.Set;

public class Every
extends Operator {
    private static final Fields AGGREGATOR_ARGUMENTS = Fields.ALL;
    private static final Fields AGGREGATOR_SELECTOR = Fields.ALL;
    private static final Fields ASSERTION_SELECTOR = Fields.RESULTS;

    @ConstructorProperties(value={"previous", "aggregator"})
    public Every(Pipe previous, Aggregator aggregator) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)aggregator, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "aggregator"})
    public Every(Pipe previous, Fields argumentSelector, Aggregator aggregator) {
        super(previous, argumentSelector, (Operation)aggregator, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "aggregator", "outputSelector"})
    public Every(Pipe previous, Fields argumentSelector, Aggregator aggregator, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)aggregator, outputSelector);
    }

    @ConstructorProperties(value={"previous", "aggregator", "outputSelector"})
    public Every(Pipe previous, Aggregator aggregator, Fields outputSelector) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)aggregator, outputSelector);
    }

    @ConstructorProperties(value={"previous", "buffer"})
    public Every(Pipe previous, Buffer buffer) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)buffer, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "buffer"})
    public Every(Pipe previous, Fields argumentSelector, Buffer buffer) {
        super(previous, argumentSelector, (Operation)buffer, AGGREGATOR_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "buffer", "outputSelector"})
    public Every(Pipe previous, Fields argumentSelector, Buffer buffer, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)buffer, outputSelector);
    }

    @ConstructorProperties(value={"previous", "buffer", "outputSelector"})
    public Every(Pipe previous, Buffer buffer, Fields outputSelector) {
        super(previous, AGGREGATOR_ARGUMENTS, (Operation)buffer, outputSelector);
    }

    @ConstructorProperties(value={"previous", "assertionLevel", "assertion"})
    public Every(Pipe previous, AssertionLevel assertionLevel, GroupAssertion assertion) {
        super(previous, AGGREGATOR_ARGUMENTS, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, ASSERTION_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "assertionLevel", "assertion"})
    public Every(Pipe previous, Fields argumentSelector, AssertionLevel assertionLevel, GroupAssertion assertion) {
        super(previous, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, ASSERTION_SELECTOR);
    }

    public boolean isBuffer() {
        return this.operation instanceof Buffer;
    }

    public boolean isAggregator() {
        return this.operation instanceof Aggregator;
    }

    public boolean isGroupAssertion() {
        return this.operation instanceof GroupAssertion;
    }

    public Aggregator getAggregator() {
        return (Aggregator)this.operation;
    }

    public Buffer getBuffer() {
        return (Buffer)this.operation;
    }

    public GroupAssertion getGroupAssertion() {
        return (GroupAssertion)this.operation;
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        if (this.isBuffer()) {
            return incomingScope.getIncomingBufferArgumentFields();
        }
        return incomingScope.getIncomingAggregatorArgumentFields();
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        if (this.isBuffer()) {
            return incomingScope.getIncomingBufferPassThroughFields();
        }
        return incomingScope.getIncomingAggregatorPassThroughFields();
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Scope incomingScope = this.getFirst(incomingScopes);
        if (!this.isBuffer() && incomingScope.getOutValuesFields().isNone()) {
            throw new OperatorException(this, "only a Buffer may be preceded by a CoGroup declaring Fields.NONE as the join fields");
        }
        Fields argumentFields = this.resolveArgumentSelector(incomingScopes);
        this.verifyArguments(argumentFields);
        this.verifyAggregatorArguments(argumentFields, incomingScope);
        Fields declaredFields = this.resolveDeclared(incomingScopes, argumentFields);
        this.verifyDeclaredFields(declaredFields);
        Fields outgoingGroupingFields = this.resolveOutgoingGroupingSelector(incomingScopes, argumentFields, declaredFields);
        this.verifyOutputSelector(outgoingGroupingFields);
        Fields outgoingValuesFields = incomingScope.getOutValuesFields();
        Fields passThroughFields = this.resolveIncomingOperationPassThroughFields(incomingScope);
        Fields remainderFields = this.resolveRemainderFields(incomingScopes, argumentFields);
        return new Scope(this.getName(), Scope.Kind.EVERY, passThroughFields, remainderFields, argumentFields, declaredFields, outgoingGroupingFields, outgoingValuesFields);
    }

    private void verifyAggregatorArguments(Fields argumentFields, Scope incomingScope) {
        if (!this.isBuffer() && incomingScope.isEvery() && argumentFields.contains(incomingScope.getOperationDeclaredFields())) {
            throw new OperatorException(this, "arguments may not select a declared field from a previous Every");
        }
    }

    Fields resolveOutgoingGroupingSelector(Set<Scope> incomingScopes, Fields argumentSelector, Fields declared) {
        try {
            return this.resolveOutgoingSelector(incomingScopes, argumentSelector, declared);
        }
        catch (Exception exception) {
            if (exception instanceof OperatorException) {
                throw (OperatorException)exception;
            }
            if (this.isBuffer()) {
                throw new OperatorException(this, "could not resolve outgoing values selector in: " + this, exception);
            }
            throw new OperatorException(this, "could not resolve outgoing grouping selector in: " + this, exception);
        }
    }
}

