/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.planner.Scope;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.Debug;
import cascading.operation.DebugLevel;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.operation.ValueAssertion;
import cascading.pipe.Operator;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.util.Set;

public class Each
extends Operator {
    private static final Fields FUNCTION_SELECTOR = Fields.RESULTS;
    private static final Fields FILTER_SELECTOR = Fields.RESULTS;

    @ConstructorProperties(value={"name", "function"})
    public Each(String name, Function function) {
        super(name, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "function"})
    public Each(String name, Fields argumentSelector, Function function) {
        super(name, argumentSelector, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "function", "outputSelector"})
    public Each(String name, Fields argumentSelector, Function function, Fields outputSelector) {
        super(name, argumentSelector, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"name", "function", "outputSelector"})
    public Each(String name, Function function, Fields outputSelector) {
        super(name, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"previous", "function"})
    public Each(Pipe previous, Function function) {
        super(previous, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "function"})
    public Each(Pipe previous, Fields argumentSelector, Function function) {
        super(previous, argumentSelector, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "function", "outputSelector"})
    public Each(Pipe previous, Fields argumentSelector, Function function, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"previous", "function", "outputSelector"})
    public Each(Pipe previous, Function function, Fields outputSelector) {
        super(previous, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"name", "filter"})
    public Each(String name, Filter filter) {
        super(name, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "filter"})
    public Each(String name, Fields argumentSelector, Filter filter) {
        super(name, argumentSelector, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "filter"})
    public Each(Pipe previous, Filter filter) {
        super(previous, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "filter"})
    public Each(Pipe previous, Fields argumentSelector, Filter filter) {
        super(previous, argumentSelector, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "assertionLevel", "assertion"})
    public Each(String name, AssertionLevel assertionLevel, Assertion assertion) {
        super(name, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "assertionLevel", "assertion"})
    public Each(String name, Fields argumentSelector, AssertionLevel assertionLevel, Assertion assertion) {
        super(name, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "assertionLevel", "assertion"})
    public Each(Pipe previous, AssertionLevel assertionLevel, Assertion assertion) {
        super(previous, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "assertionLevel", "assertion"})
    public Each(Pipe previous, Fields argumentSelector, AssertionLevel assertionLevel, Assertion assertion) {
        super(previous, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "debugLevel", "debug"})
    public Each(String name, Fields argumentSelector, DebugLevel debugLevel, Debug debug) {
        super(name, argumentSelector, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "debugLevel", "debug"})
    public Each(Pipe previous, DebugLevel debugLevel, Debug debug) {
        super(previous, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "debugLevel", "debug"})
    public Each(Pipe previous, Fields argumentSelector, DebugLevel debugLevel, Debug debug) {
        super(previous, argumentSelector, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @Override
    protected void verifyOperation() {
        if (this.plannerLevel == null && this.operation instanceof Debug) {
            this.plannerLevel = DebugLevel.DEFAULT;
        }
        super.verifyOperation();
        if (!this.argumentSelector.isArgSelector()) {
            throw new IllegalArgumentException("invalid argument selector: " + this.argumentSelector);
        }
        if (!this.operation.getFieldDeclaration().isDeclarator()) {
            throw new IllegalArgumentException("invalid field declaration: " + this.operation.getFieldDeclaration());
        }
        if (!this.outputSelector.isOutSelector()) {
            throw new IllegalArgumentException("invalid output selector: " + this.outputSelector);
        }
    }

    public Function getFunction() {
        return (Function)this.operation;
    }

    public Filter getFilter() {
        return (Filter)this.operation;
    }

    public ValueAssertion getValueAssertion() {
        return (ValueAssertion)this.operation;
    }

    public boolean isFunction() {
        return this.operation instanceof Function;
    }

    public boolean isFilter() {
        return this.operation instanceof Filter;
    }

    public boolean isValueAssertion() {
        return this.operation instanceof ValueAssertion;
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        return incomingScope.getIncomingFunctionArgumentFields();
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        return incomingScope.getIncomingFunctionPassThroughFields();
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields argumentFields = this.resolveArgumentSelector(incomingScopes);
        this.verifyArguments(argumentFields);
        Fields declaredFields = this.resolveDeclared(incomingScopes, argumentFields);
        this.verifyDeclaredFields(declaredFields);
        Fields outgoingValuesFields = this.resolveOutgoingValuesSelector(incomingScopes, argumentFields, declaredFields);
        this.verifyOutputSelector(outgoingValuesFields);
        Fields outgoingGroupingFields = Fields.asDeclaration(outgoingValuesFields);
        Fields passThroughFields = this.resolveIncomingOperationPassThroughFields(this.getFirst(incomingScopes));
        Fields remainderFields = this.resolveRemainderFields(incomingScopes, argumentFields);
        return new Scope(this.getName(), Scope.Kind.EACH, passThroughFields, remainderFields, argumentFields, declaredFields, outgoingGroupingFields, outgoingValuesFields);
    }

    Fields resolveOutgoingValuesSelector(Set<Scope> incomingScopes, Fields argumentFields, Fields declaredFields) {
        try {
            return this.resolveOutgoingSelector(incomingScopes, argumentFields, declaredFields);
        }
        catch (Exception exception) {
            if (exception instanceof OperatorException) {
                throw (OperatorException)exception;
            }
            throw new OperatorException(this, "could not resolve outgoing values selector in: " + this, exception);
        }
    }
}

