/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;

public class FieldJoiner
extends BaseOperation<Tuple>
implements Function<Tuple> {
    public static final String FIELD_NAME = "joined";
    private String delimiter = "\t";

    @ConstructorProperties(value={"delimiter"})
    public FieldJoiner(String delimiter) {
        this(new Fields(new Comparable[]{FIELD_NAME}));
        this.delimiter = delimiter;
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public FieldJoiner(Fields fieldDeclaration) {
        super(fieldDeclaration);
    }

    @ConstructorProperties(value={"fieldDeclaration", "delimiter"})
    public FieldJoiner(Fields fieldDeclaration, String delimiter) {
        super(fieldDeclaration);
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Tuple> operationCall) {
        operationCall.setContext(Tuple.size(1));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Tuple> functionCall) {
        ((Tuple)functionCall.getContext()).set(0, functionCall.getArguments().getTuple().toString(this.delimiter, false));
        functionCall.getOutputCollector().add((Tuple)functionCall.getContext());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldJoiner)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FieldJoiner that = (FieldJoiner)object;
        return !(this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        return result;
    }
}

