/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.state;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import java.beans.ConstructorProperties;

public class Counter
extends BaseOperation
implements Filter {
    private final Enum counterEnum;
    private final String groupString;
    private final String counterString;
    private final int increment;

    @ConstructorProperties(value={"counter"})
    public Counter(Enum counter) {
        this(counter, 1);
    }

    @ConstructorProperties(value={"counter", "increment"})
    public Counter(Enum counter, int increment) {
        this.counterEnum = counter;
        this.groupString = null;
        this.counterString = null;
        this.increment = increment;
    }

    @ConstructorProperties(value={"group", "counter"})
    public Counter(String group, String counter) {
        this(group, counter, 1);
    }

    @ConstructorProperties(value={"group", "counter", "increment"})
    public Counter(String group, String counter, int increment) {
        this.counterEnum = null;
        this.groupString = group;
        this.counterString = counter;
        this.increment = increment;
    }

    public Enum getCounterEnum() {
        return this.counterEnum;
    }

    public String getGroupString() {
        return this.groupString;
    }

    public String getCounterString() {
        return this.counterString;
    }

    public int getIncrement() {
        return this.increment;
    }

    public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
        if (this.counterEnum != null) {
            flowProcess.increment(this.counterEnum, this.increment);
        } else {
            flowProcess.increment(this.groupString, this.counterString, this.increment);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Counter)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Counter counter = (Counter)object;
        if (this.increment != counter.increment) {
            return false;
        }
        if (this.counterEnum != null ? !this.counterEnum.equals(counter.counterEnum) : counter.counterEnum != null) {
            return false;
        }
        if (this.counterString != null ? !this.counterString.equals(counter.counterString) : counter.counterString != null) {
            return false;
        }
        return !(this.groupString != null ? !this.groupString.equals(counter.groupString) : counter.groupString != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.counterEnum != null ? this.counterEnum.hashCode() : 0);
        result = 31 * result + (this.groupString != null ? this.groupString.hashCode() : 0);
        result = 31 * result + (this.counterString != null ? this.counterString.hashCode() : 0);
        result = 31 * result + this.increment;
        return result;
    }
}

