/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class RegexSplitter
extends RegexOperation<Pair<Pattern, TupleEntry>>
implements Function<Pair<Pattern, TupleEntry>> {
    private int length;

    @ConstructorProperties(value={"patternString"})
    public RegexSplitter(String patternString) {
        super(1, patternString);
        this.length = this.fieldDeclaration.isUnknown() ? -1 : this.fieldDeclaration.size();
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public RegexSplitter(Fields fieldDeclaration) {
        super(1, fieldDeclaration, "\t");
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexSplitter(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
        this.length = fieldDeclaration.isUnknown() ? -1 : fieldDeclaration.size();
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Pattern, TupleEntry>> operationCall) {
        this.length = operationCall.getDeclaredFields().isUnknown() ? -1 : operationCall.getDeclaredFields().size();
        TupleEntry tupleEntry = new TupleEntry(operationCall.getDeclaredFields(), Tuple.size(Math.max(1, this.length)));
        operationCall.setContext(new Pair<Pattern, TupleEntry>(this.getPattern(), tupleEntry));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Pattern, TupleEntry>> functionCall) {
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        TupleEntry output = (TupleEntry)((Pair)functionCall.getContext()).getRhs();
        Object[] split = ((Pattern)((Pair)functionCall.getContext()).getLhs()).split(value, this.length);
        if (this.length == -1) {
            output.getTuple().clear();
            for (Object element : split) {
                output.getTuple().add((Comparable)element);
            }
        } else {
            output.setCanonicalValues(split);
        }
        functionCall.getOutputCollector().add(output);
    }
}

