/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class RegexSplitGenerator
extends RegexOperation<Pair<Pattern, TupleEntry>>
implements Function<Pair<Pattern, TupleEntry>> {
    @ConstructorProperties(value={"patternString"})
    public RegexSplitGenerator(String patternString) {
        super(1, Fields.size(1), patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexSplitGenerator(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + fieldDeclaration.print());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Pattern, TupleEntry>> operationCall) {
        TupleEntry tupleEntry = new TupleEntry(operationCall.getDeclaredFields(), Tuple.size(1));
        operationCall.setContext(new Pair<Pattern, TupleEntry>(this.getPattern(), tupleEntry));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Pattern, TupleEntry>> functionCall) {
        String[] split;
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        for (String string : split = ((Pattern)((Pair)functionCall.getContext()).getLhs()).split(value)) {
            TupleEntry tupleEntry = (TupleEntry)((Pair)functionCall.getContext()).getRhs();
            tupleEntry.setString(Integer.valueOf(0), string);
            functionCall.getOutputCollector().add(tupleEntry);
        }
    }
}

