/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class RegexReplace
extends RegexOperation<Pair<Matcher, TupleEntry>>
implements Function<Pair<Matcher, TupleEntry>> {
    private final String replacement;
    private boolean replaceAll = true;

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement", "replaceAll"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement, boolean replaceAll) {
        this(fieldDeclaration, patternString, replacement);
        this.replaceAll = replaceAll;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement) {
        super(1, fieldDeclaration, patternString);
        this.replacement = replacement;
    }

    @Property(name="replacement", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The string replacement value.")
    public String getReplacement() {
        return this.replacement;
    }

    @Property(name="replaceAll", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="Will replace all occurrences of pattern.")
    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Matcher, TupleEntry>> operationCall) {
        TupleEntry tupleEntry = new TupleEntry(operationCall.getDeclaredFields(), Tuple.size(1));
        operationCall.setContext(new Pair<Matcher, TupleEntry>(this.getPattern().matcher(""), tupleEntry));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Matcher, TupleEntry>> functionCall) {
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        TupleEntry output = (TupleEntry)((Pair)functionCall.getContext()).getRhs();
        Matcher matcher = ((Matcher)((Pair)functionCall.getContext()).getLhs()).reset(value);
        if (this.replaceAll) {
            output.setString(Integer.valueOf(0), matcher.replaceAll(this.replacement));
        } else {
            output.setString(Integer.valueOf(0), matcher.replaceFirst(this.replacement));
        }
        functionCall.getOutputCollector().add(output);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexReplace)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexReplace that = (RegexReplace)object;
        if (this.replaceAll != that.replaceAll) {
            return false;
        }
        return !(this.replacement != null ? !this.replacement.equals(that.replacement) : that.replacement != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.replacement != null ? this.replacement.hashCode() : 0);
        result = 31 * result + (this.replaceAll ? 1 : 0);
        return result;
    }
}

