/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.regex.Matcher;

public class RegexParser
extends RegexOperation<Pair<Matcher, TupleEntry>>
implements Function<Pair<Matcher, TupleEntry>> {
    private int[] groups = null;

    @ConstructorProperties(value={"patternString"})
    public RegexParser(String patternString) {
        super(1, patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexParser(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
    }

    @ConstructorProperties(value={"patternString", "groups"})
    public RegexParser(String patternString, int ... groups) {
        super(1, Fields.size(RegexParser.verifyReturnLength(groups)), patternString);
        this.groups = Arrays.copyOf(groups, groups.length);
    }

    private static int verifyReturnLength(int[] groups) {
        if (groups == null || groups.length == 0) {
            throw new IllegalArgumentException("groups may not be null or 0 length");
        }
        return groups.length;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "groups"})
    public RegexParser(Fields fieldDeclaration, String patternString, int ... groups) {
        super(1, fieldDeclaration, patternString);
        RegexParser.verifyReturnLength(groups);
        this.groups = Arrays.copyOf(groups, groups.length);
        if (!fieldDeclaration.isUnknown() && fieldDeclaration.size() != groups.length) {
            throw new IllegalArgumentException("fieldDeclaration must equal number of groups to be captured, fields: " + fieldDeclaration.print());
        }
    }

    public int[] getGroups() {
        if (this.groups == null) {
            return null;
        }
        return Arrays.copyOf(this.groups, this.groups.length);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Matcher, TupleEntry>> operationCall) {
        int size = this.groups != null ? this.groups.length : operationCall.getDeclaredFields().size();
        TupleEntry entry = new TupleEntry(operationCall.getDeclaredFields(), Tuple.size(size));
        operationCall.setContext(new Pair<Matcher, TupleEntry>(this.getPattern().matcher(""), entry));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Matcher, TupleEntry>> functionCall) {
        Matcher matcher;
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        if (!(matcher = ((Matcher)((Pair)functionCall.getContext()).getLhs()).reset(value)).find()) {
            throw new OperationException("could not match pattern: [" + this.getPatternString() + "] with value: [" + value + "]");
        }
        TupleEntry output = (TupleEntry)((Pair)functionCall.getContext()).getRhs();
        if (this.groups != null) {
            this.onGivenGroups(functionCall, matcher, output);
        } else {
            this.onFoundGroups(functionCall, matcher, output);
        }
    }

    private void onFoundGroups(FunctionCall<Pair<Matcher, TupleEntry>> functionCall, Matcher matcher, TupleEntry output) {
        int count = matcher.groupCount();
        if (functionCall.getDeclaredFields().isUnknown()) {
            this.addGroupsToTuple(matcher, output, count);
        } else {
            this.setGroupsOnTuple(matcher, output, count);
        }
        functionCall.getOutputCollector().add(output.getTuple());
    }

    private void setGroupsOnTuple(Matcher matcher, TupleEntry output, int count) {
        if (count == 0) {
            try {
                output.setString(Integer.valueOf(0), matcher.group(0));
            }
            catch (Exception exception) {
                throw new CascadingException("unable to set tuple value at field: " + output.getFields().get(0) + ", from regex group: 0", exception);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                try {
                    output.setString(Integer.valueOf(i), matcher.group(i + 1));
                    continue;
                }
                catch (Exception exception) {
                    throw new CascadingException("unable to set tuple value at field: " + output.getFields().get(i) + ", from regex group: " + (i + 1), exception);
                }
            }
        }
    }

    private void addGroupsToTuple(Matcher matcher, TupleEntry output, int count) {
        Tuple tuple = output.getTuple();
        tuple.clear();
        if (count == 0) {
            tuple.add((Comparable)((Object)matcher.group(0)));
        } else {
            for (int i = 0; i < count; ++i) {
                tuple.add((Comparable)((Object)matcher.group(i + 1)));
            }
        }
    }

    private void onGivenGroups(FunctionCall<Pair<Matcher, TupleEntry>> functionCall, Matcher matcher, TupleEntry output) {
        for (int i = 0; i < this.groups.length; ++i) {
            output.setString(Integer.valueOf(i), matcher.group(this.groups[i]));
        }
        functionCall.getOutputCollector().add(output);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexParser)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexParser that = (RegexParser)object;
        return Arrays.equals(this.groups, that.groups);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.groups != null ? Arrays.hashCode(this.groups) : 0);
        return result;
    }
}

