/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class RegexOperation<C>
extends BaseOperation<C> {
    protected String patternString = ".*";

    public RegexOperation() {
    }

    @ConstructorProperties(value={"numArgs"})
    public RegexOperation(int numArgs) {
        super(numArgs);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public RegexOperation(Fields fieldDeclaration) {
        super(fieldDeclaration);
    }

    @ConstructorProperties(value={"numArgs", "patternString"})
    public RegexOperation(int numArgs, String patternString) {
        super(numArgs);
        this.patternString = patternString;
    }

    @ConstructorProperties(value={"patternString"})
    public RegexOperation(String patternString) {
        this.patternString = patternString;
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration"})
    public RegexOperation(int numArgs, Fields fieldDeclaration) {
        super(numArgs, fieldDeclaration);
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration", "patternString"})
    public RegexOperation(int numArgs, Fields fieldDeclaration, String patternString) {
        super(numArgs, fieldDeclaration);
        this.patternString = patternString;
    }

    @Property(name="patternString", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The regular expression pattern string.")
    public final String getPatternString() {
        return this.patternString;
    }

    protected Pattern getPattern() {
        return Pattern.compile(this.getPatternString());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexOperation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexOperation that = (RegexOperation)object;
        return !(this.patternString != null ? !this.patternString.equals(that.patternString) : that.patternString != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.patternString != null ? this.patternString.hashCode() : 0);
        return result;
    }
}

