/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatcher
extends RegexOperation<Matcher> {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMatcher.class);
    public static final String DEFAULT_DELIM = "\t";
    protected final boolean negateMatch;
    protected final String delimiter;

    @ConstructorProperties(value={"patternString"})
    protected RegexMatcher(String patternString) {
        super(patternString);
        this.negateMatch = false;
        this.delimiter = DEFAULT_DELIM;
    }

    @ConstructorProperties(value={"patternString", "delimiter"})
    protected RegexMatcher(String patternString, String delimiter) {
        super(patternString);
        this.negateMatch = false;
        this.delimiter = delimiter;
        if (this.delimiter == null) {
            throw new IllegalArgumentException("delimiter may not be null");
        }
    }

    @ConstructorProperties(value={"patternString", "negateMatch"})
    protected RegexMatcher(String patternString, boolean negateMatch) {
        super(patternString);
        this.negateMatch = negateMatch;
        this.delimiter = DEFAULT_DELIM;
    }

    @ConstructorProperties(value={"patternString", "negateMatch", "delimiter"})
    protected RegexMatcher(String patternString, boolean negateMatch, String delimiter) {
        super(patternString);
        this.negateMatch = negateMatch;
        this.delimiter = delimiter;
        if (this.delimiter == null) {
            throw new IllegalArgumentException("delimiter may not be null");
        }
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = false;
        this.delimiter = DEFAULT_DELIM;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "delimiter"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString, String delimiter) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = false;
        this.delimiter = delimiter;
        if (this.delimiter == null) {
            throw new IllegalArgumentException("delimiter may not be null");
        }
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "negateMatch"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString, boolean negateMatch) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = negateMatch;
        this.delimiter = DEFAULT_DELIM;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "negateMatch", "delimiter"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString, boolean negateMatch, String delimiter) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = negateMatch;
        this.delimiter = delimiter;
        if (this.delimiter == null) {
            throw new IllegalArgumentException("delimiter may not be null");
        }
        this.verify();
    }

    public final boolean isNegateMatch() {
        return this.negateMatch;
    }

    public final String getDelimiter() {
        return this.delimiter;
    }

    private void verify() {
        if (this.fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("num fields in fieldDeclaration must be one, found: " + this.fieldDeclaration.printVerbose());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    protected boolean matchWholeTuple(Matcher matcher, TupleEntry input) {
        Iterable<String> iterable = input.asIterableOf(String.class);
        String join = Util.join(iterable, this.delimiter, false);
        matcher.reset(join);
        boolean matchFound = matcher.find();
        if (LOG.isDebugEnabled()) {
            LOG.debug("pattern: {}, matches: {}", (Object)this.getPatternString(), (Object)matchFound);
        }
        return matchFound == this.negateMatch;
    }

    protected boolean matchEachElement(Matcher matcher, TupleEntry input) {
        return this.matchEachElementPos(matcher, input) != -1;
    }

    protected int matchEachElementPos(Matcher matcher, TupleEntry input) {
        int pos = 0;
        for (int i = 0; i < input.size(); ++i) {
            String value = input.getString(Integer.valueOf(i));
            if (value == null) {
                value = "";
            }
            matcher.reset(value);
            boolean matchFound = matcher.find();
            if (LOG.isDebugEnabled()) {
                LOG.debug("pattern: " + this.getPatternString() + ", matches: " + matchFound + ", element: '" + value + "'");
            }
            if (matchFound == this.negateMatch) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexMatcher)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexMatcher that = (RegexMatcher)object;
        if (this.negateMatch != that.negateMatch) {
            return false;
        }
        return !(this.delimiter == null ? that.delimiter != null : !this.delimiter.equals(that.delimiter));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.negateMatch ? 1 : 0);
        result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        return result;
    }
}

