/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.hash;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.SerFunction;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.WeakHashMap;

public abstract class BaseHashFunction
extends BaseOperation<Context>
implements Function<Context> {
    public static final String DEFAULT_ALGORITHM = "SHA-1";
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected final String algorithm;
    protected final int maxLength;
    protected final String charsetName;
    protected final SerFunction<String, String> preDigest;
    protected final SerFunction<StringBuilder, StringBuilder> postEncoding;

    public BaseHashFunction(Fields fieldDeclaration) {
        this(fieldDeclaration, DEFAULT_ALGORITHM);
    }

    public BaseHashFunction(Fields fieldDeclaration, SerFunction<String, String> preDigest, SerFunction<StringBuilder, StringBuilder> postEncoding) {
        this(fieldDeclaration, DEFAULT_ALGORITHM, Integer.MAX_VALUE, DEFAULT_CHARSET, preDigest, postEncoding);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm) {
        this(fieldDeclaration, algorithm, Integer.MAX_VALUE);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm, SerFunction<String, String> preDigest, SerFunction<StringBuilder, StringBuilder> postEncoding) {
        this(fieldDeclaration, algorithm, Integer.MAX_VALUE, DEFAULT_CHARSET, preDigest, postEncoding);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm, int maxLength) {
        this(fieldDeclaration, algorithm, maxLength, DEFAULT_CHARSET);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm, int maxLength, SerFunction<String, String> preDigest, SerFunction<StringBuilder, StringBuilder> postEncoding) {
        this(fieldDeclaration, algorithm, maxLength, DEFAULT_CHARSET, preDigest, postEncoding);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm, int maxLength, String charsetName) {
        this(fieldDeclaration, algorithm, maxLength, charsetName, null, null);
    }

    public BaseHashFunction(Fields fieldDeclaration, String algorithm, int maxLength, String charsetName, SerFunction<String, String> preDigest, SerFunction<StringBuilder, StringBuilder> postEncoding) {
        super(fieldDeclaration);
        this.algorithm = algorithm;
        this.charsetName = charsetName;
        this.maxLength = maxLength;
        this.preDigest = preDigest == null ? SerFunction.identity() : preDigest;
        SerFunction<Object, Object> serFunction = this.postEncoding = postEncoding == null ? SerFunction.identity() : postEncoding;
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + fieldDeclaration.print());
        }
        this.verify();
    }

    protected void verify() {
        this.getDigest();
        this.getCharset();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        operationCall.setContext(new Context());
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Context> functionCall) {
        Context context = (Context)functionCall.getContext();
        Tuple result = context.tuple;
        String string = this.getValue(functionCall);
        if (string == null) {
            string = "";
        }
        String encoded = context.cache.computeIfAbsent(string, value -> {
            value = (String)this.preDigest.apply((String)value);
            byte[] bytes = value.getBytes(this.getCharset());
            byte[] digest = context.digest.digest(bytes);
            StringBuilder buffer = new StringBuilder();
            this.performEncoding(buffer, digest);
            buffer = (StringBuilder)this.postEncoding.apply(buffer);
            if (buffer.length() > this.maxLength) {
                return buffer.substring(0, this.maxLength);
            }
            return buffer.toString();
        });
        result.set(0, encoded);
        functionCall.getOutputCollector().add(result);
    }

    protected abstract void performEncoding(StringBuilder var1, byte[] var2);

    protected String getValue(FunctionCall<Context> functionCall) {
        if (functionCall.getArguments().size() == 1) {
            return functionCall.getArguments().getString(Integer.valueOf(0));
        }
        Iterator<String> values = functionCall.getArguments().asIterableOf(String.class).iterator();
        StringBuilder result = new StringBuilder();
        while (values.hasNext()) {
            String next = values.next();
            if (next == null) continue;
            result.append(next);
        }
        return result.toString();
    }

    protected MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance(this.getAlgorithm());
        }
        catch (NoSuchAlgorithmException exception) {
            throw new CascadingException("unknown digest algorithm: " + this.getAlgorithm(), exception);
        }
    }

    protected Charset getCharset() {
        return Charset.forName(this.charsetName);
    }

    protected class Context {
        Tuple tuple = Tuple.size(1);
        WeakHashMap<String, String> cache = new WeakHashMap();
        MessageDigest digest = BaseHashFunction.this.getDigest();

        protected Context() {
        }
    }
}

