/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.function;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;

public class SetValue
extends BaseOperation
implements Function {
    private final Filter filter;
    private Tuple[] values = new Tuple[]{new Tuple(true), new Tuple(false)};

    @ConstructorProperties(value={"fieldDeclaration", "filter"})
    public SetValue(Fields fieldDeclaration, Filter filter) {
        super(fieldDeclaration);
        this.filter = filter;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "filter", "firstValue", "secondValue"})
    public SetValue(Fields fieldDeclaration, Filter filter, Serializable firstValue, Serializable secondValue) {
        super(fieldDeclaration);
        this.filter = filter;
        this.values = new Tuple[]{new Tuple(firstValue), new Tuple(secondValue)};
        this.verify();
    }

    @Property(name="firstValue", visibility=Visibility.PRIVATE)
    public Serializable getFirstValue() {
        return (Serializable)this.values[0].getObject(0);
    }

    @Property(name="secondValue", visibility=Visibility.PRIVATE)
    public Serializable getSecondValue() {
        return (Serializable)this.values[1].getObject(0);
    }

    private void verify() {
        if (this.fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + this.fieldDeclaration.print());
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("filter may not be null");
        }
        if (this.values == null || this.values.length != 2) {
            throw new IllegalArgumentException("values argument must contain two values");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.prepare(flowProcess, operationCall);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        boolean isRemove = !this.filter.isRemove(flowProcess, (FilterCall)((Object)functionCall));
        int pos = isRemove ? 0 : 1;
        functionCall.getOutputCollector().add(this.values[pos]);
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.cleanup(flowProcess, operationCall);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SetValue)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SetValue setValue = (SetValue)object;
        if (this.filter != null ? !this.filter.equals(setValue.filter) : setValue.filter != null) {
            return false;
        }
        return Arrays.equals(this.values, setValue.values);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.values != null ? Arrays.hashCode(this.values) : 0);
        return result;
    }
}

