/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.flow.stream.StopDataNotificationException;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.util.Traceable;
import java.beans.ConstructorProperties;

public class Stop
extends BaseOperation
implements Filter {
    private final Filter filter;

    @ConstructorProperties(value={"filter"})
    public Stop(Filter filter) {
        this.filter = filter;
        if (filter == null) {
            throw new IllegalArgumentException("filter may not be null");
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.prepare(flowProcess, operationCall);
    }

    public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
        if (this.filter.isRemove(flowProcess, filterCall)) {
            throw new StopDataNotificationException("data stopped on filter: " + this.getFilterString());
        }
        return false;
    }

    protected String getFilterString() {
        String string = this.filter.toString();
        if (this.filter instanceof Traceable) {
            string = string + " @ " + ((Traceable)((Object)this.filter)).getTrace();
        }
        return string;
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        this.filter.cleanup(flowProcess, operationCall);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Stop)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Stop not = (Stop)object;
        return !(this.filter != null ? !this.filter.equals(not.filter) : not.filter != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }
}

