/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import java.beans.ConstructorProperties;

public class Limit
extends BaseOperation<Context>
implements Filter<Context> {
    private long limit = 0L;

    @ConstructorProperties(value={"limit"})
    public Limit(long limit) {
        this.limit = limit;
    }

    @Property(name="limit", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The upper limit.")
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        super.prepare(flowProcess, operationCall);
        Context context = new Context();
        operationCall.setContext(context);
        int numTasks = flowProcess.getNumProcessSlices();
        int taskNum = flowProcess.getCurrentSliceNum();
        context.limit = (long)Math.floor((double)this.limit / (double)numTasks);
        long remainingLimit = this.limit % (long)numTasks;
        context.limit = context.limit + ((long)taskNum < remainingLimit ? 1L : 0L);
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Context> filterCall) {
        return ((Context)filterCall.getContext()).increment();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Limit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Limit limit1 = (Limit)object;
        return this.limit == limit1.limit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        return result;
    }

    public static class Context {
        public long limit = 0L;
        public long count = 0L;

        public boolean increment() {
            if (this.limit == this.count) {
                return true;
            }
            ++this.count;
            return false;
        }
    }
}

