/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.operation.AssertionException;
import cascading.operation.AssertionLevel;
import cascading.operation.BaseOperation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.util.TraceUtil;
import java.beans.ConstructorProperties;

public abstract class BaseAssertion<C>
extends BaseOperation<C>
implements PlannedOperation<C> {
    private String message;

    protected BaseAssertion() {
    }

    @ConstructorProperties(value={"message"})
    protected BaseAssertion(String message) {
        this.message = message;
    }

    @ConstructorProperties(value={"numArgs"})
    protected BaseAssertion(int numArgs) {
        super(numArgs);
    }

    @ConstructorProperties(value={"numArgs", "message"})
    protected BaseAssertion(int numArgs, String message) {
        super(numArgs);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean supportsPlannerLevel(PlannerLevel plannerLevel) {
        return plannerLevel instanceof AssertionLevel;
    }

    protected void fail() {
        BaseAssertion.throwFail(TraceUtil.formatTrace(this, this.getMessage()));
    }

    protected void fail(Object ... args) {
        BaseAssertion.throwFail(TraceUtil.formatTrace(this, this.getMessage()), args);
    }

    public static void throwFail(String message) {
        throw new AssertionException(message);
    }

    public static void throwFail(String message, Object ... args) {
        throw new AssertionException(String.format(message, args));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseAssertion)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BaseAssertion that = (BaseAssertion)object;
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

