/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.GroupAssertion;
import cascading.operation.GroupAssertionCall;
import cascading.operation.OperationCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertGroupBase
extends BaseAssertion<Context>
implements GroupAssertion<Context> {
    private static final Logger LOG = LoggerFactory.getLogger(AssertGroupBase.class);
    protected String patternString;
    protected final long size;

    @ConstructorProperties(value={"message", "size"})
    public AssertGroupBase(String message, long size) {
        super(message);
        this.size = size;
    }

    @ConstructorProperties(value={"message", "patternString", "size"})
    protected AssertGroupBase(String message, String patternString, long size) {
        super(message);
        this.patternString = patternString;
        this.size = size;
    }

    @Property(name="patternString", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The regular expression pattern string.")
    public String getPatternString() {
        return this.patternString;
    }

    public long getSize() {
        return this.size;
    }

    private Pattern getPattern() {
        Pattern pattern = this.patternString == null ? Pattern.compile(".*") : Pattern.compile(this.patternString);
        return pattern;
    }

    private boolean matchWholeTuple(Tuple input, Pattern pattern) {
        if (this.patternString == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(input.toString("\t", false));
        LOG.debug("pattern: {}, matches: {}", (Object)pattern, (Object)matcher.matches());
        return matcher.matches();
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        operationCall.setContext(new Context());
        operationCall.getContext().pattern = this.getPattern();
    }

    @Override
    public void start(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        TupleEntry groupEntry = assertionCall.getGroup();
        Context context = (Context)assertionCall.getContext();
        if (!this.matchWholeTuple(groupEntry.getTuple(), context.pattern)) {
            context.reset();
        } else {
            context.set(0L, groupEntry.getFields().print(), groupEntry.getTuple().print());
        }
    }

    @Override
    public void aggregate(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        Long groupSize = ((Context)assertionCall.getContext()).count;
        if (groupSize != null) {
            Context context = (Context)assertionCall.getContext();
            context.count = context.count + 1L;
        }
    }

    @Override
    public void doAssert(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        Context context = (Context)assertionCall.getContext();
        Long groupSize = context.count;
        if (groupSize == null) {
            return;
        }
        if (this.assertFails(groupSize)) {
            if (this.patternString == null) {
                this.fail(groupSize, this.size, context.fields, context.group);
            } else {
                this.fail(this.patternString, groupSize, this.size, context.fields, context.group);
            }
        }
    }

    protected abstract boolean assertFails(Long var1);

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertGroupBase)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AssertGroupBase that = (AssertGroupBase)object;
        if (this.size != that.size) {
            return false;
        }
        return !(this.patternString != null ? !this.patternString.equals(that.patternString) : that.patternString != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.patternString != null ? this.patternString.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public static class Context {
        Pattern pattern;
        Long count;
        String fields;
        String group;

        public Context set(long count, String fields, String group) {
            this.count = count;
            this.fields = fields;
            this.group = group;
            return this;
        }

        public Context reset() {
            this.count = null;
            this.fields = null;
            this.group = null;
            return this;
        }
    }
}

