/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ExtentBase
extends BaseOperation<Tuple[]>
implements Aggregator<Tuple[]> {
    private final Collection<Tuple> ignoreTuples;

    @ConstructorProperties(value={"fieldDeclaration"})
    protected ExtentBase(Fields fieldDeclaration) {
        super(fieldDeclaration);
        this.ignoreTuples = null;
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration"})
    protected ExtentBase(int numArgs, Fields fieldDeclaration) {
        super(numArgs, fieldDeclaration);
        this.ignoreTuples = null;
    }

    @ConstructorProperties(value={"fieldDeclaration", "ignoreTuples"})
    protected ExtentBase(Fields fieldDeclaration, Tuple ... ignoreTuples) {
        super(fieldDeclaration);
        this.ignoreTuples = new HashSet<Tuple>();
        Collections.addAll(this.ignoreTuples, ignoreTuples);
    }

    public Collection<Tuple> getIgnoreTuples() {
        return Collections.unmodifiableCollection(this.ignoreTuples);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Tuple[]> operationCall) {
        operationCall.setContext(new Tuple[1]);
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        ((Tuple[])aggregatorCall.getContext())[0] = null;
    }

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        if (this.ignoreTuples != null && this.ignoreTuples.contains(aggregatorCall.getArguments().getTuple())) {
            return;
        }
        this.performOperation((Tuple[])aggregatorCall.getContext(), aggregatorCall.getArguments());
    }

    protected abstract void performOperation(Tuple[] var1, TupleEntry var2);

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        if (((Tuple[])aggregatorCall.getContext())[0] != null) {
            aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
        }
    }

    protected Tuple getResult(AggregatorCall<Tuple[]> aggregatorCall) {
        return ((Tuple[])aggregatorCall.getContext())[0];
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExtentBase)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExtentBase that = (ExtentBase)object;
        return !(this.ignoreTuples != null ? !this.ignoreTuples.equals(that.ignoreTuples) : that.ignoreTuples != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ignoreTuples != null ? this.ignoreTuples.hashCode() : 0);
        return result;
    }
}

